<?php

namespace Bongo\Builder\Http\Controllers\Api;

use Bongo\Builder\Facades\ComponentFacade;
use Bongo\Framework\Http\Controllers\AbstractApiController;
use Illuminate\Http\Request;

class SnippetController extends AbstractApiController
{
    public function index(Request $request)
    {
        if (config('settings.memory_limit') && ! empty(config('settings.memory_limit'))) {
            ini_set('memory_limit', config('settings.memory_limit'));
        }

        $categories = ComponentFacade::categories();

        $category = $request->get('category', 'basic');
        $components = ComponentFacade::findByCategory($category);

        return view('builder::api.snippets', compact('components', 'categories'))->render();
    }
}
