<?php

namespace Bongo\Builder\Http\Middleware;

use Bongo\Framework\Helpers\ShortCode;
use Closure;
use Illuminate\Contracts\Container\BindingResolutionException;

/**
 * Class HasShortCodes
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2022 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   App\Redirect\Http\Middleware
 */
class HasShortCodes
{
    /**
     * @param $request
     * @param Closure $next
     *
     * @return mixed
     * @throws BindingResolutionException
     */
    public function handle($request, Closure $next)
    {
        // Get the next response and see if it has any html content or bail
        $response = $next($request);
        if (!method_exists($response, 'content')) {
            return $response;
        }

        // Check if the html contains shortcodes and if it does replace them
        $content = ShortCode::parse($response->content());

        // Update the response and return
        $response->setContent($content);

        return $response;
    }
}
