<?php

use Illuminate\Support\Facades\Route;

// Api Routes...
Route::namespace('Bongo\Builder\Http\Controllers\Api')
    ->middleware(['noIndex'])
    ->prefix(config('settings.api_prefix'))
    ->as('api.')
    ->group(function () {
        Route::group(['as' => 'builder.', 'prefix' => 'builder'], function () {

            Route::get('/')
                ->name('index')
                ->uses('ComponentController@index')
                ->middleware('auth:api');

            Route::get('buttons')
                ->name('button.index')
                ->uses('ButtonController@index');

            Route::get('designs')
                ->name('design.index')
                ->uses('DesignController@index');

            Route::get('snippets')
                ->name('snippet.index')
                ->uses('SnippetController@index');

            Route::get('files')
                ->name('file.index')
                ->uses('FileController@index');

            Route::get('fonts')
                ->name('font.index')
                ->uses('FontController@index');

            Route::get('images')
                ->name('image.index')
                ->uses('ImageController@index');

            Route::get('icons')
                ->name('icon.index')
                ->uses('IconController@index');

            Route::get('symbols')
                ->name('symbol.index')
                ->uses('SymbolController@index');

            Route::get('styles')
                ->name('style.index')
                ->uses('StyleController@index');

            Route::get('modules/{module}')
                ->name('module.index')
                ->uses('ModuleController@index');

            Route::get('carousels/{carousel}')
                ->name('carousel.index')
                ->uses('CarouselController@index');

            Route::get('sliders/{slider}')
                ->name('slider.index')
                ->uses('SliderController@index');

            Route::get('validation')
                ->name('validation.index')
                ->uses('ValidationController@index');

            Route::get('review')
                ->name('review.index')
                ->uses('ReviewController@index');

            Route::get('review-summary')
                ->name('review_summary.index')
                ->uses('ReviewSummaryController@index');

            Route::get('form-builder')
                ->name('form_builder.index')
                ->uses('FormController@index');

            Route::get('gallery-builder')
                ->name('gallery_builder.index')
                ->uses('GalleryController@index');
        });
    });
