<?php

use Illuminate\Support\Facades\Route;

// Backend Routes...
Route::namespace('Bongo\Builder\Http\Controllers')
     ->middleware('web')
     ->group(function () {
         Route::namespace('Backend')
              ->middleware(['auth', 'employee'])
              ->prefix(config('settings.backend_prefix'))
              ->as('backend.')
              ->group(function () {

                  // Component
                  Route::as('component.')
                       ->prefix(config('builder.component_prefix'))
                       ->group(function () {
                           Route::get('/')->name('index')->uses('ComponentController@index');
                           Route::get('create')->name('create')->uses('ComponentController@create');
                           Route::post('store')->name('store')->uses('ComponentController@store');

                           // Component/{key}/
                           Route::prefix('{key}')
                                ->group(function () {
                                    Route::get('/')->name('show')->uses('ComponentController@show');
                                    Route::get('edit')->name('edit')->uses('ComponentController@edit');
                                    Route::post('update')->name('update')->uses('ComponentController@update');
                                    Route::delete('delete')->name('destroy')->uses('ComponentController@destroy');
                                });
                       });

                  // Design
                  Route::as('design.')
                       ->prefix(config('builder.design_prefix'))
                       ->group(function () {
                           Route::get('/')->name('index')->uses('DesignController@index');
                           Route::get('create')->name('create')->uses('DesignController@create');
                           Route::post('store')->name('store')->uses('DesignController@store');

                           // Design/{key}/
                           Route::prefix('{key}')
                                ->group(function () {
                                    Route::get('/')->name('show')->uses('DesignController@show');
                                    Route::get('edit')->name('edit')->uses('DesignController@edit');
                                    Route::post('update')->name('update')->uses('DesignController@update');
                                    Route::delete('delete')->name('destroy')->uses('DesignController@destroy');
                                });
                       });
              });
     });
