<!DOCTYPE HTML>
<html>
    <head>
        <meta charset="utf-8">
        <title>Designs</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <link rel="stylesheet" href="{{ config('builder.backend_asset_path') }}/designs/css/designs.css">
    </head>
    <body class="h-100">

        @if($categories && count($categories) > 0)
            <div id="snippet-list">
                <svg style="display:none">
                    <defs>
                        <symbol viewBox="0 0 512 512" id="ion-ios-close-empty">
                            <path
                                d="M340.2 160l-84.4 84.3-84-83.9-11.8 11.8 84 83.8-84 83.9 11.8 11.7 84-83.8 84.4 84.2 11.8-11.7-84.4-84.3 84.4-84.2z"
                            ></path>
                        </symbol>
                    </defs>
                </svg>

                <div class="is-pop-close"
                     style="z-index:10; width:30px; height:30px; position:absolute; top:0px; right:0px; box-sizing:border-box; padding:0; line-height:40px; font-size: 12px; color:#777;text-align:center;cursor:pointer;"
                >
                    <svg class="is-icon-flex" style="fill:rgba(0, 0, 0, 0.47); width:30px; height:30px;">
                        <use xlink:href="#ion-ios-close-empty"></use>
                    </svg>
                </div>

                <div class="is-category-list">
                    <div class="is-categories"
                         style="position:fixed; top:0; left:0; right:0; height:68px; padding-top:17px; box-sizing:border-box;"
                    >
                        @foreach($categories as $key => $category)
                            @if(in_array($key, ['buttons', 'custom', 'services']))
                                @continue
                            @endif
                            <a href="{{ route('api.builder.design.index', ['category' => $key]) }}"
                               class="{{ request()->get('category', 'basic') === $key ? 'active' : '' }}"
                               data-cat="{{ $key }}"
                            >
                                <span>{{ ucwords(str_replace('_', ' ', $category)) }}</span>
                            </a>
                        @endforeach
                    </div>
                </div>

                <div class="is-design-list">
                    @foreach($designs as $design)
                        <div class="design is-design"
                             data-id="{{ $design->key }}"
                             data-cat="{{ $design->category }}"
                             data-html="{{ json_encode(preg_replace('/[\t\s\n]*(<.*>)[\t\s\n]*/', '$1', $design->getHtml())) }}"
                        >
                            <img class="lazyload" src="{{ $design->getThumbnail() }}" alt="Preview" loading="lazy">
                            <span>{{ ucwords($design->name) }}</span>
                        </div>
                    @endforeach
                </div>
            </div>
        @else
            <div class="message text-center">
                <div class="message-text font-semibold">
                    No sections found, please check directory contents
                </div>
            </div>
        @endif

        <script src="{{ config('builder.vendor_asset_path') }}/jquery.js" type="text/javascript"></script>
        <script src="{{ config('builder.backend_asset_path') }}/designs/js/designs-v2.js" type="text/javascript"></script>
    </body>
</html>
