<!DOCTYPE HTML>
<html class="h-100">
    <head>
        <meta charset="utf-8">
        <title>Images</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <link rel="stylesheet" href="{{ config('builder.vendor_asset_path') }}/bootstrap.css">
        <link href="{{ config('builder.backend_asset_path') }}/images/css/images.css" rel="stylesheet" type="text/css"/>
    </head>
    <body class="h-100">

        @if(isset($images) && count($images) > 0)
            <div id="wrapper" class="h-100 w-100 d-flex flex-column">
                <div id="content" class="d-flex flex-grow-1 align-items-center justify-content-center">
                    <div id="files" class="w-100">
                        @foreach($images as $image)
                            <div class="file">
                                <img
                                    class="lazyload"
                                    src="{{ '/' . config('image.prefix') . "/{$image->name}?w=105&h=90&mode=resizeFit&q=5" }}"
                                    data-src="{{ '/' . config('image.prefix') . "/{$image->name}?w=105&h=90&mode=resizeFit" }}"
                                    width="105px"
                                    alt="{{ $image->title }}"
                                    loading="lazy"
                                />
                            </div>
                        @endforeach
                    </div>
                </div>
                <div id="links" class="content d-flex align-items-center justify-content-center">
                    {{ $images->links() }}
                </div>
            </div>
        @else
            <div class="text-center">
                <h3>No Images Found...</h3>
            </div>
        @endif

        <script src="{{ config('builder.vendor_asset_path') }}/lazy.js"></script>
        <script src="{{ config('builder.backend_asset_path') }}/images/js/images.js"></script>
    </body>
</html>
