@foreach($reviews as $review)
    <div class="item" data-subblock>
        <div class="review">
            <div class="review-rating">
                <div class="rating-stars">
                    <span class="fa fa-star {{ $review->rating >= 1 ? 'checked' : '' }}"></span>
                    <span class="fa fa-star {{ $review->rating >= 2 ? 'checked' : '' }}"></span>
                    <span class="fa fa-star {{ $review->rating >= 3 ? 'checked' : '' }}"></span>
                    <span class="fa fa-star {{ $review->rating >= 4 ? 'checked' : '' }}"></span>
                    <span class="fa fa-star {{ $review->rating >= 5 ? 'checked' : '' }}"></span>
                </div>
                <div class="rating-count">
                    <span class="count-number">{{ $review->rating }}</span> out of <span class="count-total">5</span>
                </div>
            </div>
            @if($showTitle)
                <div class="review-title">
                    <a href="{{ route('frontend.review.show', $review->uuid) }}">
                        {{ $review->title }}
                    </a>
                </div>
            @endif
            <div class="review-content">
                {{ $review->getSummary($characters) }}
            </div>
            <div class="review-name">
                {{ $review->name }}
            </div>
        </div>
    </div>
@endforeach
