<section class="md:grid md:grid-cols-2 md:gap-6">

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'name',
                        'value' => $component->getName(),
                        'placeholder' => 'heading-1',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label'    => 'Category',
                        'name'     => 'category',
                        'value'    => $component->getCategory(),
                        'options'  => $component->categories()
                    ])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        <label class="block text-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-sm group text-gray-400 cursor-pointer hover:bg-white hover:text-primary-500 hover:border-primary-500">
            <span class="block">
                <svg class="mx-auto h-10 w-10" stroke="currentColor" fill="none"
                     viewBox="0 0 48 48" aria-hidden="true"
                >
                    <path
                        d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02"
                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    ></path>
                </svg>
            </span>
            <span class="block text-xs">
                Upload PNG Thumbnail
            </span>
            <input class="hidden" type="file" name="thumbnail" accept="image/png" />
        </label>
    </div>
</section>

<section class="md:grid md:grid-cols-1 md:gap-6 mt-6">

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-2">
                    <editor html="{{ $component->getHtml() }}"></editor>
                </div>
            </div>
        @endcomponent
    </div>
</section>
