<?php

$id = Str::random(5);

$moduleHtml = '
    <form id="'.$id.'" class="contact-form" action="/contact/store" method="POST">
        <div class="validation" style="display: none;"></div>

        <div class="form-group">
            <input class="form-control" name="name"
                   type="text"
                   maxlength="100" value=""
                   data-msg-required="Please enter your name."
                   placeholder="Your Name..."
                   required
            >
        </div>

        <div class="form-group">
            <input class="form-control" name="email"
                   type="email" maxlength="100"
                   data-msg-required="Please enter your email address."
                   data-msg-email="Please enter a valid email address."
                   placeholder="Your Email Address..."
                   required
            >
        </div>

        <div class="form-group">
            <textarea class="form-control" name="message"
                      maxlength="5000"
                      data-msg-required="Please enter your message."
                      placeholder="Your Message..."
                      required
            ></textarea>
        </div>

        <div class="form-group">
            <button class="form-submit btn btn-primary font-weight-bold text-uppercase"
                    type="submit">
                Submit
            </button>
        </div>
    </form>
';

$moduleHtml .= '
    <script>
        /**
         * Generate csrf
         */
        function '.$id.'_generateCsrfField() {
            let csrfField = document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", document.head.querySelector(\'meta[name="csrf-token"]\').content);

            return csrfField;
        }

        /**
         * Set the component validation
         */
        function '.$id.'_setValidation() {
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function() {
                if (xmlhttp.readyState === XMLHttpRequest.DONE) {
                    if (xmlhttp.status === 200) {
                        let formContainer = document.getElementById("'.$id.'");
                        let validationContainer = formContainer.getElementsByClassName("validation")[0];

                        validationContainer.innerHTML = xmlhttp.responseText;
                        validationContainer.prepend('.$id.'_generateCsrfField());

                        let reCaptchaContainer = validationContainer.getElementsByClassName("recaptcha-container")[0];
                        let reCaptchaEnabled = reCaptchaContainer && reCaptchaContainer.getAttribute("data-recaptcha");
                        if (reCaptchaEnabled === "1") {
                            let reCaptchaKey = reCaptchaContainer.getAttribute("data-recaptcha-key");
                            let reCaptchaField = reCaptchaContainer.getAttribute("data-recaptcha-field");
                            let reCaptchaAction = reCaptchaContainer.getAttribute("data-recaptcha-action");

                            window.grecaptcha.ready(function () {
                                window.grecaptcha
                                    .execute(reCaptchaKey, {action : reCaptchaAction})
                                    .then(function (token) {
                                        let input = document.getElementById(reCaptchaField).value = token;
                                    });
                            });
                        }

                    } else {
                        console.log("Status error: " + xmlhttp.status);
                    }
                }
            };
            xmlhttp.open("GET", "/api/builder/validation", true);
            xmlhttp.send();
        }

        /**
         * Document ready function
         */
        var '.$id.'_docReady = function (fn) {
            var stateCheck = setInterval(function () {
                if (document.readyState !== "complete") return;
                clearInterval(stateCheck);
                    try { fn() } catch (e) { }
                }, 1);
        };
        '.$id.'_docReady(function () {
            '.$id.'_setValidation();
        });
    </script>
';

$moduleSettings = '
    {
        "style": "form-inline",
        "button_style": "btn-primary",
        "name": false,
        "firstName": true,
        "lastName": true,
        "email": true,
        "phone": true,
        "message": false
    }
';
?>

<div class="row clearfix">
    <div class="col-12"
         data-module="contact-form"
         data-dialog-width="500px"
         data-module-desc="Contact Form"
         data-html="{{ encode_uri_component($moduleHtml) }}"
         data-settings="{{ encode_uri_component($moduleSettings) }}"
    >
    </div>
</div>
