<?php

$id = Str::random(5);

$moduleHtml = '
    <div id="'.$id.'" class="new-review-slider bongo-carousel owl-theme bongo-reviews slider style-1">
        <div class="item" data-subblock>
            <div class="review">
                <div class="review-rating">
                    <div class="rating-stars">
                        <span class="fa fa-star checked"></span>
                        <span class="fa fa-star checked"></span>
                        <span class="fa fa-star checked"></span>
                        <span class="fa fa-star"></span>
                        <span class="fa fa-star"></span>
                    </div>
                    <div class="rating-count">
                        <span class="count-number">3</span> out of <span class="count-total">5</span>
                    </div>
                </div>
                <div class="review-content">
                    What can I say, absolute A1 service by Neil Burr and the team.
                </div>
                <div class="review-name">
                    By Designtec
                </div>
            </div>
        </div>
    </div>

    <script>
        var '.$id.'_docReady = function (fn) {
            var stateCheck = setInterval(function () {
                if (document.readyState !== "complete") return;
                clearInterval(stateCheck);
                try {fn()} catch (e) {}
            }, 1000);
        };
        '.$id.'_docReady(function () {
            var clones = document.querySelectorAll(".cloned");
            Array.prototype.forEach.call(clones, function (clone) {
                clone.removeAttribute("data-subblock");
                clone.childNodes[0].removeAttribute("data-subblock");
            });

            $("#'.$id.'").owlCarousel({
                items: 1,
                margin: 0,
                loop: false,
                nav: false,
                dots: false,
                smartSpeed: 1000,
                fluidSpeed: 1000,
                autoWidth: true,
                autoplay: false,
                autoplayHoverPause: false
            });
            document.getElementById("'.$id.'").style.display = "block";

            $(".owl-dots").remove();
            $(".owl-nav").remove();
        });
    </script>
';

$moduleSettings = '
    {
        "type": "slider",
        "items": 1,
        "style": "style-1",
        "margin": 0,
        "loop": true,
        "nav": false,
        "dots": false,
        "speed": 1000,
        "autoplay": true,
        "autoplay_pause": true,
        "show_title": true,
        "number_characters": 100,
        "number_reviews": 5
    }
';
?>

<div class="row clearfix border-0">
    <div class="col-12"
         data-noedit
         data-module="review"
         data-module-desc="Reviews"
         data-html="{{ encode_uri_component($moduleHtml) }}"
         data-settings="{{ encode_uri_component($moduleSettings) }}"
    >
    </div>
</div>
