/**
 * Get the active button
 */
function getActiveButton() {
    return parent._cb.activeLink;
}

/**
 * Save for undo
 */
function saveForUndo() {
    parent._cb.uo.saveForUndo();
}

/**
 * Notify the parent
 */
function notifyParentOfChange() {
    parent._cb.opts.onChange();
}

/**
 *
 * @param element
 * @param classname
 */
function addClass(element, classname) {
    if (!element) return;
    if (hasClass(element, classname)) return;
    if (element.classList.length === 0) element.className = classname;
    else element.className = element.className + ' ' + classname;
    element.className = element.className.replace(/  +/g, ' ');
}

/**
 *
 * @param element
 * @param classname
 * @returns {boolean}
 */
function hasClass(element, classname) {
    if (!element) return false;
    return element.classList
        ? element.classList.contains(classname)
        : new RegExp('\\b' + classname + '\\b').test(element.className);
}

/**
 *
 * @param element
 * @param classname
 */
function removeClass(element, classname) {
    if (!element) return;
    if (element.classList.length > 0) {
        element.className = element.className.replace(classname, '');
    }
}

/**
 * Remove all inline styles
 *
 * @param element
 */
function removeInlineStyles(element) {
    parent._cb.uo.saveForUndo();
    element.setAttribute('style', '');
    parent._cb.opts.onChange();
}

/**
 *
 * @returns {string[]}
 */
function getButtonStyles() {
    return [
        'btn-primary',
        'btn-secondary',
        'btn-tertiary',
        'btn-quaternary',
        'btn-color-5',
        'btn-color-6',
        'btn-color-7',
        'btn-color-8',

        'btn-success',
        'btn-danger',
        'btn-warning',
        'btn-info',
        'btn-light',
        'btn-dark',
        'btn-link',

        'btn-outline-primary',
        'btn-outline-secondary',
        'btn-outline-tertiary',
        'btn-outline-quaternary',
        'btn-outline-color-5',
        'btn-outline-color-6',
        'btn-outline-color-7',
        'btn-outline-color-8',

        'btn-outline-success',
        'btn-outline-danger',
        'btn-outline-warning',
        'btn-outline-info',
        'btn-outline-light',
        'btn-outline-dark',
    ]
}

/**
 *
 * @returns {string[]}
 */
function getButtonSizes() {
    return [
        'btn-sm',
        'btn-md',
        'btn-lg',
        'btn-xl',
    ]
}

/**
 *
 * @returns {string[]}
 */
function getButtonLayouts() {
    return [
        'btn-inline',
        'btn-block',
    ]
}

/**
 * Restore the existing settings
 */
function restoreExistingSettings() {

    let activeButton = getActiveButton();

    let btnStyles = getButtonStyles();
    btnStyles.forEach(function myFunction(value) {
        if (hasClass(activeButton, value)) {
            document.querySelector('#style').value = value;
        }
    });

    let btnSizes = getButtonSizes();
    btnSizes.forEach(function myFunction(value) {
        if (hasClass(activeButton, value)) {
            document.querySelector('#size').value = value;
        }
    });

    let btnLayouts = getButtonLayouts();
    btnLayouts.forEach(function myFunction(value) {
        if (hasClass(activeButton, value)) {
            document.querySelector('#layout').value = value;
        }
    });
}

/**
 * Register form events
 */
function registerFormEvents() {

    let activeButton = getActiveButton();

    // Style
    document.querySelector('#style').addEventListener('change', function (e) {
        saveForUndo();
        removeInlineStyles(activeButton);

        // Remove existing styles
        let btnStyles = getButtonStyles();
        btnStyles.forEach(function myFunction(value) {
            removeClass(activeButton, value);
        });

        // Add the new styles
        addClass(activeButton, e.target.value);

        notifyParentOfChange();
    });

    // Size
    document.querySelector('#size').addEventListener('change', function (e) {
        saveForUndo();
        removeInlineStyles(activeButton);

        // Remove existing size
        let btnSizes = getButtonSizes();
        btnSizes.forEach(function myFunction(value) {
            removeClass(activeButton, value);
        });

        // Add the new size
        addClass(activeButton, e.target.value);

        notifyParentOfChange();
    });

    // Layout
    document.querySelector('#layout').addEventListener('change', function (e) {
        saveForUndo();
        removeInlineStyles(activeButton);

        // Remove existing layout
        let btnLayouts = getButtonLayouts();
        btnLayouts.forEach(function myFunction(value) {
            removeClass(activeButton, value);
        });

        // Add the new layout
        addClass(activeButton, e.target.value);

        notifyParentOfChange();
    });
}

// Set the default options to match the element
restoreExistingSettings();

// Register the events
registerFormEvents();