import { Util, Dom } from './util.js';

const util = new Util();
const dom = new Dom();

const prepareSvgIcons = () => {

    const html = `<svg width="0" height="0" style="position:absolute;display:none;">
        <defs>
            <symbol viewBox="0 0 512 512" id="ion-ios-arrow-left"><path d="M352 115.4L331.3 96 160 256l171.3 160 20.7-19.3L201.5 256z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-arrow-right"><path d="M160 115.4L180.7 96 352 256 180.7 416 160 396.7 310.5 256z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-plus-outline"><path d="M256 48C141.1 48 48 141.1 48 256s93.1 208 208 208 208-93.1 208-208S370.9 48 256 48zm0 398.7c-105.1 0-190.7-85.5-190.7-190.7S150.9 65.3 256 65.3 446.7 150.9 446.7 256 361.1 446.7 256 446.7z"></path><path d="M264.1 128h-16.8v119.9H128v16.8h119.3V384h16.8V264.7H384v-16.8H264.1z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-image"><path d="M368 224c26.5 0 48-21.5 48-48s-21.5-48-48-48-48 21.5-48 48 21.5 48 48 48z"></path><path d="M452 64H60c-15.6 0-28 12.7-28 28.3v327.4c0 15.6 12.4 28.3 28 28.3h392c15.6 0 28-12.7 28-28.3V92.3c0-15.6-12.4-28.3-28-28.3zM348.9 261.7c-3-3.5-7.6-6.2-12.8-6.2-5.1 0-8.7 2.4-12.8 5.7L304.6 277c-3.9 2.8-7 4.7-11.5 4.7-4.3 0-8.2-1.6-11-4.1-1-.9-2.8-2.6-4.3-4.1L224 215.3c-4-4.6-10-7.5-16.7-7.5-6.7 0-12.9 3.3-16.8 7.8L64 368.2V107.7c1-6.8 6.3-11.7 13.1-11.7h357.7c6.9 0 12.5 5.1 12.9 12l.3 260.4-99.1-106.7z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-photos-outline"><path d="M96 128v320h384V128H96zm368 304H112V144h352v288z"></path><path d="M32 64v320h48v-16H48V80h352v32h16V64z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-settings-strong"><path d="M32 376h283.35c6.186-14.112 20.281-24 36.65-24s30.465 9.888 36.65 24H480v32h-91.35c-6.186 14.112-20.281 24-36.65 24s-30.465-9.888-36.65-24H32M32 240h91.35c6.186-14.112 20.281-24 36.65-24s30.465 9.888 36.65 24H480v32H196.65c-6.186 14.112-20.281 24-36.65 24s-30.465-9.888-36.65-24H32M32 104h283.35c6.186-14.112 20.281-24 36.65-24s30.465 9.888 36.65 24H480v32h-91.35c-6.186 14.112-20.281 24-36.65 24s-30.465-9.888-36.65-24H32"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-settings"><path d="M352 104c8.837 0 16 7.163 16 16s-7.163 16-16 16-16-7.163-16-16 7.163-16 16-16m0-16c-17.645 0-32 14.355-32 32s14.355 32 32 32 32-14.355 32-32-14.355-32-32-32zM352 376c8.837 0 16 7.163 16 16s-7.163 16-16 16-16-7.163-16-16 7.163-16 16-16m0-16c-17.645 0-32 14.355-32 32s14.355 32 32 32 32-14.355 32-32-14.355-32-32-32zM160 240c8.837 0 16 7.163 16 16s-7.163 16-16 16-16-7.163-16-16 7.163-16 16-16m0-16c-17.645 0-32 14.355-32 32s14.355 32 32 32 32-14.355 32-32-14.355-32-32-32zM207.32 248H480v16H207.32c.439-2.604.68-5.273.68-8s-.24-5.396-.68-8zM112 256c0 2.727.24 5.396.68 8H32v-16h80.68a47.955 47.955 0 0 0-.68 8zM399.32 384H480v16h-80.68c.439-2.604.68-5.273.68-8s-.24-5.396-.68-8zM304 392c0 2.727.24 5.396.68 8H32v-16h272.68a47.955 47.955 0 0 0-.68 8zM399.32 112H480v16h-80.68c.439-2.604.68-5.273.68-8s-.24-5.396-.68-8zM304.68 112c-.439 2.604-.68 5.273-.68 8s.24 5.396.68 8H32v-16h272.68z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-android-options"><path d="M32 384h272v32H32zM400 384h80v32h-80zM384 447.5c0 17.949-14.327 32.5-32 32.5-17.673 0-32-14.551-32-32.5v-95c0-17.949 14.327-32.5 32-32.5 17.673 0 32 14.551 32 32.5v95z"></path><g><path d="M32 240h80v32H32zM208 240h272v32H208zM192 303.5c0 17.949-14.327 32.5-32 32.5-17.673 0-32-14.551-32-32.5v-95c0-17.949 14.327-32.5 32-32.5 17.673 0 32 14.551 32 32.5v95z"></path></g><g><path d="M32 96h272v32H32zM400 96h80v32h-80zM384 159.5c0 17.949-14.327 32.5-32 32.5-17.673 0-32-14.551-32-32.5v-95c0-17.949 14.327-32.5 32-32.5 17.673 0 32 14.551 32 32.5v95z"></path></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-list-number"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-1043.45,1024 C-1039.25,946.283 -1023.18,878.648 -995.249,821.096 C-967.313,763.544 -912.806,711.242 -831.728,664.192 L-710.742,594.247 C-656.55,562.74 -618.532,535.854 -596.687,513.589 C-562.24,478.722 -545.016,438.813 -545.016,393.863 C-545.016,341.352 -560.769,299.658 -592.276,268.781 C-623.783,237.904 -665.792,222.466 -718.304,222.466 C-796.02,222.466 -849.792,251.873 -879.619,310.685 C-895.582,342.192 -904.404,385.882 -906.084,441.754 L-1021.4,441.754 C-1020.14,363.197 -1005.65,299.133 -977.92,249.562 C-928.769,162.183 -842.02,118.494 -717.673,118.494 C-614.331,118.494 -538.82,146.43 -491.139,202.302 C-443.459,258.174 -419.619,320.347 -419.619,388.822 C-419.619,461.078 -445.034,522.831 -495.865,574.082 C-525.272,603.909 -577.993,640.037 -654.03,682.466 L-740.358,730.356 C-781.527,753.041 -813.874,774.676 -837.399,795.26 C-879.408,831.808 -905.874,872.347 -916.797,916.877 L-424.03,916.877 L-424.03,1024 L-1043.45,1024 Z "  /><path d="M-922.391,-764.384 L-922.391,-851.343 C-840.474,-859.324 -783.341,-872.662 -750.994,-891.356 C-718.647,-910.05 -694.492,-954.265 -678.529,-1024 L-589.049,-1024 L-589.049,-125.425 L-710.035,-125.425 L-710.035,-764.384 L-922.391,-764.384 Z "  /><path d="M-198.618,-510.942 L-198.618,-667.156 L1004.57,-667.156 L1004.57,-510.942 L-198.618,-510.942 Z "  /><path d="M-198.618,78.1071 L-198.618,-78.1071 L1004.57,-78.1071 L1004.57,78.1071 L-198.618,78.1071 Z "  /><path d="M-179.185,649.354 L-179.185,493.14 L1024,493.14 L1024,649.354 L-179.185,649.354 Z "  /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-list-bullet"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-379.801,-514.33 L-379.801,-670.545 L914.662,-670.545 L914.662,-514.33 L-379.801,-514.33 Z "  /><path d="M-379.801,78.1071 L-379.801,-78.1071 L914.662,-78.1071 L914.662,78.1071 L-379.801,78.1071 Z "  /><path d="M-379.801,670.545 L-379.801,514.33 L914.662,514.33 L914.662,670.545 L-379.801,670.545 Z "  /><path d="M-929.642,-469.441 L-929.642,-715.434 L-669.092,-715.434 L-669.092,-469.441 L-929.642,-469.441 Z "  /><path d="M-929.642,127.109 L-929.642,-118.885 L-669.092,-118.885 L-669.092,127.109 L-929.642,127.109 Z "  /><path d="M-929.642,715.434 L-929.642,469.441 L-669.092,469.441 L-669.092,715.434 L-929.642,715.434 Z "  /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-clean"><g transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M75.0013,893.849 L-1030.73,900.993 L-32.1518,-880.838 L1009.54,-880.838 L75.0013,893.849 Z " /><path d="M-30.8571,780.685 L-845.2,787.828 L-508.893,193.749 L305.26,194.963 L-30.8571,780.685 Z " fill="#ffffff" fill-opacity="1.00" /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-align-full"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-770.727,738.299 L-770.727,582.085 L769.712,582.085 L769.712,738.299 L-770.727,738.299 Z " /><path d="M-770.727,-534.628 L-770.727,-690.842 L769.712,-690.842 L769.712,-534.628 L-770.727,-534.628 Z " /><path d="M-770.219,-115.563 L-770.219,-271.777 L770.219,-271.777 L770.219,-115.563 L-770.219,-115.563 Z " /><path d="M-770.219,303.503 L-770.219,147.288 L770.219,147.288 L770.219,303.503 L-770.219,303.503 Z " /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-align-center"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-770.727,738.299 L-770.727,582.085 L769.712,582.085 L769.712,738.299 L-770.727,738.299 Z " /><path d="M-552.286,-107.697 L-552.286,-263.911 L552.286,-263.911 L552.286,-107.697 L-552.286,-107.697 Z " /><path d="M-467.355,319.234 L-467.355,163.02 L466.34,163.02 L466.34,319.234 L-467.355,319.234 Z " /><path d="M-770.727,-534.628 L-770.727,-690.842 L769.712,-690.842 L769.712,-534.628 L-770.727,-534.628 Z " /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-align-left"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-770.727,738.299 L-770.727,582.085 L769.712,582.085 L769.712,738.299 L-770.727,738.299 Z " /><path d="M-770.727,-534.628 L-770.727,-690.842 L769.712,-690.842 L769.712,-534.628 L-770.727,-534.628 Z " /><path d="M-770.219,-115.563 L-770.219,-271.777 L482.839,-271.777 L482.839,-115.563 L-770.219,-115.563 Z " /><path d="M-770.219,303.503 L-770.219,147.288 L122.787,147.288 L122.787,303.503 L-770.219,303.503 Z " /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-align-right"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-770.727,738.299 L-770.727,582.085 L769.712,582.085 L769.712,738.299 L-770.727,738.299 Z " /><path d="M-770.727,-534.628 L-770.727,-690.842 L769.712,-690.842 L769.712,-534.628 L-770.727,-534.628 Z " /><path d="M-483.346,-118.081 L-483.346,-274.295 L769.712,-274.295 L769.712,-118.081 L-483.346,-118.081 Z " /><path d="M-123.871,303.503 L-123.871,147.288 L769.136,147.288 L769.136,303.503 L-123.871,303.503 Z " /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-indent"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-829.04,-514.33 L-829.04,-670.545 L808.959,-670.545 L808.959,-514.33 L-829.04,-514.33 Z " /><path d="M-829.04,670.545 L-829.04,514.33 L808.959,514.33 L808.959,670.545 L-829.04,670.545 Z " /><path d="M-254.279,-110.244 L-254.279,-266.458 L808.959,-266.458 L808.959,-110.244 L-254.279,-110.244 Z " /><path d="M-254.279,266.458 L-254.279,110.244 L808.959,110.244 L808.959,266.458 L-254.279,266.458 Z " /><path d="M-829.04,-195.117 L-490.958,-1.03508e-14 L-829.04,195.117 L-829.04,-195.117 Z " /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-outdent"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-829.04,-514.33 L-829.04,-670.545 L808.959,-670.545 L808.959,-514.33 L-829.04,-514.33 Z " /><path d="M-829.04,670.545 L-829.04,514.33 L808.959,514.33 L808.959,670.545 L-829.04,670.545 Z " /><path d="M-829.04,-110.244 L-829.04,-266.458 L234.198,-266.458 L234.198,-110.244 L-829.04,-110.244 Z " /><path d="M-829.04,266.458 L-829.04,110.244 L234.198,110.244 L234.198,266.458 L-829.04,266.458 Z " /><path d="M808.959,-195.117 L470.877,-1.03508e-14 L808.959,195.117 L808.959,-195.117 Z " /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-table"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M-660.783,660.783 L660.783,660.783 L660.783,-660.783 L-660.783,-660.783 L-660.783,660.783 Z " fill="none" stroke-width="75.82" stroke="#000000" stroke-linecap="square" stroke-linejoin="miter" /><path d="M-37.9645,698.933 L37.9645,698.933 L37.9645,-698.569 L-37.9645,-698.569 L-37.9645,698.933 Z " fill="#000000" fill-opacity="1.00" stroke-width="0.25" stroke="#000000" stroke-linecap="square" stroke-linejoin="miter" /><path d="M-698.933,-37.7825 L-698.933,38.1465 L698.569,38.1465 L698.569,-37.7825 L-698.933,-37.7825 Z " fill="#000000" fill-opacity="1.00" stroke-width="0.25" stroke="#000000" stroke-linecap="square" stroke-linejoin="miter" /></g></symbol>
            <symbol viewBox="0 0 512 512" id="ion-android-happy"><path d="M256 48C140.563 48 48 141.6 48 256s92.563 208 208 208 208-93.6 208-208S370.401 48 256 48zm0 374.4c-91.518 0-166.404-74.883-166.404-166.4 0-91.518 74.887-166.4 166.404-166.4S422.404 164.482 422.404 256 347.518 422.4 256 422.4zm72.8-187.2c17.683 0 31.201-13.518 31.201-31.2s-13.519-31.2-31.201-31.2c-17.682 0-31.2 13.518-31.2 31.2s13.518 31.2 31.2 31.2zm-145.6 0c17.682 0 31.2-13.518 31.2-31.2s-13.519-31.2-31.2-31.2c-17.683 0-31.201 13.518-31.201 31.2s13.519 31.2 31.201 31.2zM256 370.4c48.883 0 89.436-30.164 106.081-72.801H149.919C166.564 340.236 207.117 370.4 256 370.4z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-android-create"><path d="M64 368v80h80l235.727-235.729-79.999-79.998L64 368zm377.602-217.602c8.531-8.531 8.531-21.334 0-29.865l-50.135-50.135c-8.531-8.531-21.334-8.531-29.865 0l-39.468 39.469 79.999 79.998 39.469-39.467z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-minus-empty"><path d="M384 265H128v-17h256v17z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-eye"><path d="M256 128c-81.9 0-145.7 48.8-224 128 67.4 67.7 124 128 224 128 99.9 0 173.4-76.4 224-126.6C428.2 198.6 354.8 128 256 128zm0 219.3c-49.4 0-89.6-41-89.6-91.3 0-50.4 40.2-91.3 89.6-91.3s89.6 41 89.6 91.3c0 50.4-40.2 91.3-89.6 91.3z"></path><path d="M256 224c0-7.9 2.9-15.1 7.6-20.7-2.5-.4-5-.6-7.6-.6-28.8 0-52.3 23.9-52.3 53.3s23.5 53.3 52.3 53.3 52.3-23.9 52.3-53.3c0-2.3-.2-4.6-.4-6.9-5.5 4.3-12.3 6.9-19.8 6.9-17.8 0-32.1-14.3-32.1-32z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-reply"><path d="M448 400s-36.8-208-224-208v-80L64 256l160 134.4v-92.3c101.6 0 171 8.9 224 101.9z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-redo"><path d="M64 400h10.3l19.2-31.2c20.5-32.7 44.9-62.8 75.8-76.6 24.4-10.9 46.7-18.9 86.7-20V352l192-128L256 96v80.3c-63 2.8-108.1 20.7-143.3 56.2C60.4 285.2 64 351.5 64 368.2c.1 8.9 0 21.7 0 31.8z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-wrench"><path d="M461.9 114.9l-56.5 56.7-55.1-10-9.9-55.1 56.5-56.7c-12.7-12.7-30.8-18.5-44.2-17.8-13.5.7-42.3 8.3-64.6 32-21.6 22.8-44.3 65.3-24.2 112.5 2.4 5.7 5.1 13.2-2.9 21.2-8.1 8-215 202.8-215 202.8-19.4 16.7-18 47.6-.1 65.6 18.2 17.9 48.9 19 65.6-.3 0 0 193.2-205.8 202.7-215.1 8.5-8.3 16.1-5.5 21.2-2.9 35.6 18.4 86.3 2.4 112.6-23.9 26.3-26.3 31.1-51.7 31.9-64.7.8-12.9-3.7-30-18-44.3zM91.3 443.2c-6.3 6.2-16.5 6.2-22.7 0-6.2-6.3-6.2-16.5 0-22.7 6.3-6.2 16.5-6.2 22.7 0 6.2 6.3 6.2 16.5 0 22.7z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-more"><path d="M113.7 304C86.2 304 64 282.6 64 256c0-26.5 22.2-48 49.7-48 27.6 0 49.8 21.5 49.8 48 0 26.6-22.2 48-49.8 48zM256 304c-27.5 0-49.8-21.4-49.8-48 0-26.5 22.3-48 49.8-48 27.5 0 49.7 21.5 49.7 48 0 26.6-22.2 48-49.7 48zM398.2 304c-27.5 0-49.8-21.4-49.8-48 0-26.5 22.2-48 49.8-48 27.5 0 49.8 21.5 49.8 48 0 26.6-22.2 48-49.8 48z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-code-working"><circle cx="184.166" cy="256.166" r="24"></circle><circle cx="256.166" cy="256.166" r="24"></circle><circle cx="328.166" cy="256.166" r="24"></circle><g><path d="M168 392a23.929 23.929 0 0 1-16.971-7.029l-112-112c-9.373-9.373-9.373-24.569 0-33.941l112-112c9.373-9.372 24.568-9.372 33.941 0 9.371 9.372 9.371 24.568 0 33.941L89.941 256l95.029 95.029c9.371 9.372 9.371 24.568 0 33.941A23.925 23.925 0 0 1 168 392zM344 392a23.929 23.929 0 0 0 16.971-7.029l112-112c9.373-9.373 9.373-24.569 0-33.941l-112-112c-9.373-9.372-24.568-9.372-33.941 0-9.371 9.372-9.371 24.568 0 33.941L422.059 256l-95.029 95.029c-9.371 9.372-9.371 24.568 0 33.941A23.925 23.925 0 0 0 344 392z"></path></g></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-gear"><path d="M416.349 256.046c-.001-21.013 13.143-38.948 31.651-46.062a196.302 196.302 0 0 0-23.664-57.139 49.423 49.423 0 0 1-20.082 4.254c-12.621 0-25.238-4.811-34.871-14.442-14.863-14.863-18.248-36.846-10.18-54.97A196.274 196.274 0 0 0 302.074 64C294.971 82.529 277.027 95.69 256 95.69c-21.025 0-38.969-13.161-46.073-31.69a196.243 196.243 0 0 0-57.128 23.688c8.068 18.122 4.683 40.104-10.181 54.97-9.631 9.631-22.25 14.443-34.871 14.443a49.429 49.429 0 0 1-20.083-4.255A196.273 196.273 0 0 0 64 209.984c18.509 7.112 31.652 25.049 31.652 46.062 0 21.008-13.132 38.936-31.63 46.054a196.318 196.318 0 0 0 23.692 57.128 49.428 49.428 0 0 1 20.032-4.232c12.622 0 25.239 4.812 34.871 14.443 14.841 14.841 18.239 36.781 10.215 54.889a196.257 196.257 0 0 0 57.13 23.673c7.128-18.479 25.046-31.596 46.038-31.596 20.992 0 38.91 13.115 46.037 31.596a196.234 196.234 0 0 0 57.132-23.675c-8.023-18.106-4.626-40.046 10.216-54.887 9.629-9.632 22.248-14.444 34.868-14.444 6.836 0 13.67 1.411 20.033 4.233a196.318 196.318 0 0 0 23.692-57.128c-18.498-7.119-31.629-25.048-31.629-46.054zM256.9 335.9c-44.3 0-80-35.9-80-80 0-44.101 35.7-80 80-80 44.299 0 80 35.899 80 80 0 44.1-35.701 80-80 80z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-arrow-expand"><path d="M274 209.7l63.9-63.8L288 96h128v128l-49.9-49.9-63.8 63.9zM274 302.3l63.9 63.8L288 416h128V288l-49.9 49.9-63.8-63.9zM238 302.3l-63.9 63.8L224 416H96V288l49.9 49.9 63.8-63.9zM238 209.7l-63.9-63.8L224 96H96v128l49.9-49.9 63.8 63.9z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-android-expand"><path d="M396.795 396.8H320V448h128V320h-51.205zM396.8 115.205V192H448V64H320v51.205zM115.205 115.2H192V64H64v128h51.205zM115.2 396.795V320H64v128h128v-51.205z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-arrow-move"><path d="M480 256l-96-96v76H276V128h76l-96-96-96 96h76v108H128v-76l-96 96 96 96v-76h108v108h-76l96 96 96-96h-76.2l-.4-108.5 108.6.3V352z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-drag"><path d="M0 144h512v32H0zM0 240h512v32H0zM0 336h512v32H0z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-link"><path d="M74.6 256c0-38.3 31.1-69.4 69.4-69.4h88V144h-88c-61.8 0-112 50.2-112 112s50.2 112 112 112h88v-42.6h-88c-38.3 0-69.4-31.1-69.4-69.4zm85.4 22h192v-44H160v44zm208-134h-88v42.6h88c38.3 0 69.4 31.1 69.4 69.4s-31.1 69.4-69.4 69.4h-88V368h88c61.8 0 112-50.2 112-112s-50.2-112-112-112z"/></symbol>
            <symbol viewBox="0 0 512 512" id="ion-contrast"><path d="M256 32C132.3 32 32 132.3 32 256s100.3 224 224 224 224-100.3 224-224S379.7 32 256 32zm135.8 359.8C355.5 428 307 448 256 448V64c51 0 99.5 20 135.8 56.2C428 156.5 448 204.7 448 256c0 51.3-20 99.5-56.2 135.8z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-plus-empty"><path d="M384 265H264v119h-17V265H128v-17h119V128h17v120h120v17z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-arrow-thin-up"><path d="M349.7 189.8c-3.1 3.1-8 3-11.3 0L264 123.4V408c0 4.4-3.6 8-8 8s-8-3.6-8-8V123.4l-74.4 66.3c-3.4 2.9-8.1 3.2-11.2.1-3.1-3.1-3.3-8.5-.1-11.4 0 0 87-79.2 88-80s2.8-2.4 5.7-2.4 4.9 1.6 5.7 2.4 88 80 88 80c1.5 1.5 2.3 3.6 2.3 5.7s-.8 4.1-2.3 5.7z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-arrow-thin-down"><path d="M349.7 322.2c-3.1-3.1-8-3-11.3 0L264 388.6V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v284.6l-74.4-66.3c-3.4-2.9-8.1-3.2-11.2-.1-3.1 3.1-3.3 8.5-.1 11.4 0 0 87 79.2 88 80s2.8 2.4 5.7 2.4 4.9-1.6 5.7-2.4 88-80 88-80c1.5-1.5 2.3-3.6 2.3-5.7s-.8-4.1-2.3-5.7z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-arrow-thin-left"><path d="M189.8 349.7c3.1-3.1 3-8 0-11.3L123.4 264H408c4.4 0 8-3.6 8-8s-3.6-8-8-8H123.4l66.3-74.4c2.9-3.4 3.2-8.1.1-11.2-3.1-3.1-8.5-3.3-11.4-.1 0 0-79.2 87-80 88S96 253.1 96 256s1.6 4.9 2.4 5.7 80 88 80 88c1.5 1.5 3.6 2.3 5.7 2.3s4.1-.8 5.7-2.3z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-arrow-thin-right"><path d="M322.2 349.7c-3.1-3.1-3-8 0-11.3l66.4-74.4H104c-4.4 0-8-3.6-8-8s3.6-8 8-8h284.6l-66.3-74.4c-2.9-3.4-3.2-8.1-.1-11.2 3.1-3.1 8.5-3.3 11.4-.1 0 0 79.2 87 80 88s2.4 2.8 2.4 5.7-1.6 4.9-2.4 5.7-80 88-80 88c-1.5 1.5-3.6 2.3-5.7 2.3s-4.1-.8-5.7-2.3z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-close-empty"><path d="M340.2 160l-84.4 84.3-84-83.9-11.8 11.8 84 83.8-84 83.9 11.8 11.7 84-83.8 84.4 84.2 11.8-11.7-84.4-84.3 84.4-84.2z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-android-more-vertical"><path d="M296 136c0-22.002-17.998-40-40-40s-40 17.998-40 40 17.998 40 40 40 40-17.998 40-40zm0 240c0-22.002-17.998-40-40-40s-40 17.998-40 40 17.998 40 40 40 40-17.998 40-40zm0-120c0-22.002-17.998-40-40-40s-40 17.998-40 40 17.998 40 40 40 40-17.998 40-40z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-quote"><path d="M192 64c-40.646 0-72.483 11.229-94.627 33.373C75.229 119.517 64 151.354 64 192v256h160V192h-96c0-23.056 4.922-39.666 14.627-49.373C152.334 132.922 168.944 128 192 128M416 64c-40.646 0-72.483 11.229-94.627 33.373C299.229 119.517 288 151.354 288 192v256h160V192h-96c0-23.056 4.922-39.666 14.627-49.373C376.334 132.922 392.944 128 416 128"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-code"><path d="M168 392a23.929 23.929 0 0 1-16.971-7.029l-112-112c-9.373-9.373-9.373-24.569 0-33.941l112-112c9.373-9.372 24.568-9.372 33.941 0 9.371 9.372 9.371 24.568 0 33.941L89.941 256l95.029 95.029c9.371 9.373 9.371 24.568 0 33.941A23.925 23.925 0 0 1 168 392zM344 392a23.929 23.929 0 0 0 16.971-7.029l112-112c9.373-9.373 9.373-24.569 0-33.941l-112-112c-9.373-9.372-24.568-9.372-33.941 0-9.371 9.372-9.371 24.568 0 33.941L422.059 256l-95.029 95.029c-9.371 9.373-9.371 24.568 0 33.941A23.925 23.925 0 0 0 344 392z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-camera"><path d="M430.4 147h-67.5l-40.4-40.8s-.2-.2-.3-.2l-.2-.2c-6-6-14.1-9.8-23.3-9.8h-84c-9.8 0-18.5 4.2-24.6 10.9v.1l-39.5 40h-69C63 147 48 161.6 48 180.2v202.1c0 18.6 15 33.7 33.6 33.7h348.8c18.5 0 33.6-15.1 33.6-33.7V180.2c0-18.6-15.1-33.2-33.6-33.2zM256 365.5c-50.9 0-92.4-41.6-92.4-92.6 0-51.1 41.5-92.6 92.4-92.6 51 0 92.4 41.5 92.4 92.6 0 51-41.4 92.6-92.4 92.6zm168.1-165c-7.7 0-14-6.3-14-14.1s6.3-14.1 14-14.1 14 6.3 14 14.1-6.3 14.1-14 14.1z"></path><path d="M256 202.9c-38.6 0-69.8 31.3-69.8 70 0 38.6 31.2 70 69.8 70 38.5 0 69.8-31.3 69.8-70s-31.3-70-69.8-70z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-move"><path d="M475.9 246.2l-79.4-79.4c-5.4-5.4-14.2-5.4-19.6 0l-.2.2c-5.4 5.4-5.4 14.2 0 19.6l54.9 54.9-161.8.5.5-161.8 54.9 54.9c5.4 5.4 14.2 5.4 19.6 0l.2-.2c5.4-5.4 5.4-14.2 0-19.6l-79.4-79.4c-5.4-5.4-14.2-5.4-19.6 0l-79.4 79.4c-5.4 5.4-5.4 14.2 0 19.6l.2.2c5.4 5.4 14.2 5.4 19.6 0l54.9-54.9.5 161.8-161.8-.5 54.9-54.9c5.4-5.4 5.4-14.2 0-19.6l-.2-.2c-5.4-5.4-14.2-5.4-19.6 0l-79.4 79.4c-5.4 5.4-5.4 14.2 0 19.6l79.4 79.4c5.4 5.4 14.2 5.4 19.6 0l.2-.2c5.4-5.4 5.4-14.2 0-19.6L80 270.5l161.8-.5-.5 161.8-54.9-54.9c-5.4-5.4-14.2-5.4-19.6 0l-.2.2c-5.4 5.4-5.4 14.2 0 19.6l79.4 79.4c5.4 5.4 14.2 5.4 19.6 0l79.4-79.4c5.4-5.4 5.4-14.2 0-19.6l-.2-.2c-5.4-5.4-14.2-5.4-19.6 0l-54.9 54.9-.5-161.8 161.8.5-54.9 54.9c-5.4 5.4-5.4 14.2 0 19.6l.2.2c5.4 5.4 14.2 5.4 19.6 0l79.4-79.4c5.5-5.4 5.5-14.2 0-19.6z"/></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-ok"><rect x="0" y="0" width="2048.00" height="2048.00" fill="#ffffff" /><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M330.323,493.628 L330.323,398.406 L-330.323,398.406 L-330.323,493.628 L330.323,493.628 Z " fill="#011534" fill-opacity="1.00" /><path d="M230.718,468.568 L328.59,468.568 L328.59,-599.718 L230.718,-599.718 L230.718,468.568 Z " fill="#011534" fill-opacity="1.00" /><path d="M-300.714,376.053 L-373.748,449.088 L-68.5805,754.255 L4.45387,681.221 L-300.714,376.053 Z " fill="#011534" fill-opacity="1.00" /><path d="M-9.9476e-14,216.241 L-73.0344,143.207 L-378.202,448.375 L-305.168,521.409 L-9.9476e-14,216.241 Z " fill="#011534" fill-opacity="1.00" /></g></symbol>
            <symbol viewBox="0 0 512 512" id="ion-grid"><path d="M160 153.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5zM288 153.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5zM416 153.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5z"></path><g><path d="M160 281.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5zM288 281.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5zM416 281.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5z"></path></g><g><path d="M160 409.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5zM288 409.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5zM416 409.3c0 3.7-3 6.7-6.7 6.7h-50.5c-3.7 0-6.7-3-6.7-6.7v-50.5c0-3.7 3-6.7 6.7-6.7h50.5c3.7 0 6.7 3 6.7 6.7v50.5z"></path></g></symbol>
            <symbol viewBox="0 0 512 512" id="ion-gear-b"><path d="M448 294.4v-76.8h-42.8c-3.4-14.4-8.9-28-16.1-40.5l29.8-29.7-54.3-54.3-29.1 29.1c-12.6-7.7-26.4-13.5-41.1-17.3V64h-76.8v40.9c-14.7 3.8-28.5 9.7-41.1 17.3l-29.1-29.1-54.3 54.3 29.8 29.7c-7.2 12.5-12.6 26.1-16.1 40.5H64v76.8h44.1c3.8 13.7 9.5 26.6 16.7 38.6l-31.7 31.7 54.3 54.3 32.3-32.3c11.7 6.8 24.5 11.9 37.9 15.4v46h76.8v-46c13.5-3.5 26.2-8.6 37.9-15.4l32.3 32.3 54.3-54.3-31.6-31.7c7.2-11.9 12.9-24.8 16.7-38.6h44zm-192 15.4c-29.7 0-53.7-24.1-53.7-53.8s24-53.8 53.7-53.8 53.8 24.1 53.8 53.8-24.1 53.8-53.8 53.8z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-grid-view-outline"><path d="M448 192v-16H336V64h-16v112H192V64h-16v112H64v16h112v128H64v16h112v112h16V336h128v112h16V336h112v-16H336V192h112zM320 320H192V192h128v128z"></path></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-increase"><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M852.574,595.004 L852.574,507.837 L-852.574,507.837 L-852.574,595.004 L852.574,595.004 Z " /><path d="M852.574,224.232 L852.574,137.066 L-852.574,137.066 L-852.574,224.232 L852.574,224.232 Z " /><path d="M852.574,-134.971 L852.574,-222.138 L-852.574,-222.138 L-852.574,-134.971 L852.574,-134.971 Z " /><path d="M852.574,-505.743 L852.574,-592.909 L-852.574,-592.909 L-852.574,-505.743 L852.574,-505.743 Z " /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-decrease"><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M509.832,595.004 L509.832,507.837 L-509.832,507.837 L-509.832,595.004 L509.832,595.004 Z " /><path d="M509.832,224.232 L509.832,137.066 L-509.832,137.066 L-509.832,224.232 L509.832,224.232 Z " /><path d="M509.832,-136.947 L509.832,-224.113 L-509.832,-224.113 L-509.832,-136.947 L509.832,-136.947 Z " /><path d="M509.832,-505.743 L509.832,-592.909 L-509.832,-592.909 L-509.832,-505.743 L509.832,-505.743 Z " /></g></symbol>
            <symbol viewBox="0 0 2048.0 2048.0" id="icon-strike"><g id="document" transform="matrix(1,0,0,1,1024.0,1024.0)"><path d="M298.298,-653.766 C292.151,-624.873 284.005,-605.663 273.862,-596.135 C263.719,-586.607 250.656,-581.842 234.673,-581.842 C220.535,-581.842 196.253,-589.526 161.828,-604.895 C87.4454,-637.475 17.0588,-653.766 -49.3321,-653.766 C-155.68,-653.766 -243.28,-621.339 -312.129,-556.485 C-380.979,-491.631 -415.404,-414.328 -415.404,-324.578 C-415.404,-272.94 -403.724,-225.606 -380.364,-182.575 C-357.005,-139.544 -322.733,-100.201 -277.551,-64.5467 C-232.368,-28.8923 -156.295,18.903 -49.3321,78.8392 C57.631,138.775 123.1,177.964 147.074,196.406 C182.729,223.455 209.008,252.654 225.913,284.005 C242.819,315.357 251.271,346.401 251.271,377.137 C251.271,432.463 228.987,480.412 184.419,520.984 C139.851,561.556 79.1465,581.842 2.30524,581.842 C-64.0856,581.842 -125.098,567.089 -180.731,537.582 C-236.364,508.075 -277.704,471.037 -304.753,426.469 C-331.801,381.901 -353.316,314.742 -369.299,224.991 L-403.417,224.991 L-403.417,653.766 L-369.299,653.766 C-364.996,624.873 -358.388,605.817 -349.474,596.596 C-340.561,587.375 -328.42,582.764 -313.051,582.764 C-297.068,582.764 -259.109,592.446 -199.173,611.81 C-139.236,631.174 -99.74,642.393 -80.6834,645.467 C-48.7174,651 -14.5998,653.766 21.6692,653.766 C137.239,653.766 231.753,619.495 305.214,550.952 C378.674,482.41 415.404,400.804 415.404,306.136 C415.404,256.343 403.878,208.701 380.826,163.211 C357.773,117.721 324.885,78.2244 282.161,44.7216 C239.438,11.2188 159.676,-36.8838 42.8774,-99.5863 C-100.355,-176.428 -191.027,-237.901 -229.141,-284.005 C-255.574,-315.357 -268.791,-350.089 -268.791,-388.202 C-268.791,-437.995 -247.89,-482.41 -206.088,-521.445 C-164.287,-560.48 -111.42,-579.998 -47.4879,-579.998 C9.06727,-579.998 63.7783,-565.552 116.645,-536.66 C169.512,-507.767 210.238,-468.732 238.823,-419.554 C267.408,-370.375 287.233,-304.292 298.298,-221.303 L332.415,-221.303 L332.415,-653.766 L298.298,-653.766 Z " fill="#000000" fill-opacity="1.00" /><path d="M-530.954,-41.4477 L-530.954,41.4477 L530.954,41.4477 L530.954,-41.4477 L-530.954,-41.4477 Z " fill="#000000" fill-opacity="1.00" /></g></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-undo"><path d="M447.9 368.2c0-16.8 3.6-83.1-48.7-135.7-35.2-35.4-80.3-53.4-143.3-56.2V96L64 224l192 128v-79.8c40 1.1 62.4 9.1 86.7 20 30.9 13.8 55.3 44 75.8 76.6l19.2 31.2H448c0-10.1-.1-22.9-.1-31.8z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-ios-redo"><path d="M64 400h10.3l19.2-31.2c20.5-32.7 44.9-62.8 75.8-76.6 24.4-10.9 46.7-18.9 86.7-20V352l192-128L256 96v80.3c-63 2.8-108.1 20.7-143.3 56.2C60.4 285.2 64 351.5 64 368.2c.1 8.9 0 21.7 0 31.8z"></path></symbol>
            <symbol viewBox="0 0 512 512" id="ion-android-arrow-dropdown"><path d="M128 192l128 128 128-128z"></path></symbol>
            </defs>
        </svg>`;

    const builderstuff = util.builderStuff();
    dom.appendHtml(builderstuff, html);
};

export default prepareSvgIcons;