<?php

namespace Bongo\Builder\Http\Controllers\Api;

use Bongo\Builder\Facades\DesignFacade;
use Bongo\Framework\Http\Controllers\AbstractApiController;
use Illuminate\Http\Request;

class DesignController extends AbstractApiController
{
    public function index(Request $request)
    {
        if (config('settings.memory_limit') && ! empty(config('settings.memory_limit'))) {
            ini_set('memory_limit', config('settings.memory_limit'));
        }

        $categories = DesignFacade::categories();

        $category = $request->get('category', 'basic');
        $designs = DesignFacade::findByCategory($category);

        return view('builder::api.designs', compact('designs', 'categories'))->render();
    }
}
