<!DOCTYPE HTML>
<html>
    <head>
        <meta charset="utf-8">
        <title>Files</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <link href="{{ config('builder.backend_asset_path') }}/files/css/files.css" rel="stylesheet" type="text/css"/>
    </head>
    <body>

        @if(isset($files) && count($files) > 0)
            <div id="files">
                @foreach($files as $file)
                    <div class="file">
                        <a href="{{ asset($file->src) }}">
                            <div class="icon">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                     xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                          d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"
                                    />
                                </svg>
                            </div>
                            <div class="name">
                                {{ $file->name }}
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center">
                <h3>No Files Found...</h3>
            </div>
        @endif

        <script src="{{ config('builder.backend_asset_path') }}/files/js/files.js"></script>
    </body>
</html>
