@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $layout->name }}
        @slot('actions')
            @deleteButton([
                'name' => trans('builder::backend.layout_delete'),
                'url' => route('backend.layout.destroy', $layout->key)
            ])
            @backButton([
                'name' => trans('builder::backend.layout_index'),
                'url' => route('backend.layout.index')
            ])
            @editButton([
                'name' => trans('builder::backend.layout_edit'),
                'url' => route('backend.layout.edit', $layout->key)
            ])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Name', 'value' => $layout->getName()])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Category', 'value' => $layout->getCategory()])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                <img class="border border-solid border-light-700 max-h-40 w-100" src="{{ $layout->getThumbnail() }}"
                     alt="Layout Preview"
                >
            </div>

            <div class="md:col-span-2">
                <preview
                    html="{{ $layout->getHtml() }}"
                    frontend-css="{{ asset("/css/frontend.css") }}"
                    box-css="{{ config('builder.frontend_asset_path') }}/{{ config('builder.frontend_css_file') }}"
                ></preview>
            </div>

        </section>
    @endcomponent
@stop
