<?php

$id = Str::random(5);

$moduleHtml = '
    <form id="{id}" class="contact-form has-captcha" action="/contact/store" method="POST">
        <div class="validation" style="display: none;"></div>

        <div class="form-group">
            <input class="form-control" name="name"
                   type="text"
                   maxlength="100" value=""
                   data-msg-required="Please enter your name."
                   placeholder="Your Name..."
                   required
            >
        </div>

        <div class="form-group">
            <input class="form-control" name="email"
                   type="email" maxlength="100"
                   data-msg-required="Please enter your email address."
                   data-msg-email="Please enter a valid email address."
                   placeholder="Your Email Address..."
                   required
            >
        </div>

        <div class="form-group">
            <textarea class="form-control" name="message"
                      maxlength="5000"
                      data-msg-required="Please enter your message."
                      placeholder="Your Message..."
                      required
            ></textarea>
        </div>

        <div class="form-group">
            <button class="form-submit btn btn-primary font-weight-bold text-uppercase"
                    type="submit">
                Submit
            </button>
        </div>
    </form>
';

$moduleHtml .= '
    <script>
        var docReady{id} = function (fn) {
            var stateCheck = setInterval(function () {
                if (document.readyState !== "complete") return;
                clearInterval(stateCheck);
                try {fn()} catch (e) {}
            }, 1000);
        };
        docReady{id}(function () {
            let validationRequest{id} = new ValidationRequest("{id}");
            validationRequest{id}.init();
        });
    </script>
';

$moduleHtml = str_replace('{id}', $id, $moduleHtml);

$moduleSettings = '
    {
        "style": "form-inline",
        "button_style": "btn-primary",
        "name": false,
        "firstName": true,
        "lastName": true,
        "email": true,
        "phone": true,
        "message": false
    }
';
?>

<div class="row clearfix">
    <div class="col-12"
         data-module="contact-form"
         data-dialog-width="500px"
         data-module-desc="Contact Form"
         data-html="{{ encode_uri_component($moduleHtml) }}"
         data-settings="{{ encode_uri_component($moduleSettings) }}"
    >
    </div>
</div>
