<?php

$id = Str::random(5);

$moduleHtml = '
    <div id="'.$id.'" class="new-slider bongo-carousel owl-theme bongo-slides slider style-1">
        <div data-subblock>
            <div class="slider style-1 item position-relative">
                <img
                    data-noresize
                    data-sync
                    src="'.config('builder.frontend_asset_path').'/placeholders/square.jpg" data-src="'.config('builder.frontend_asset_path').'/placeholders/square.jpg" alt=""
                />
            </div>
        </div>
    </div>

    <script>
        var '.$id.'_docReady = function (fn) {
            var stateCheck = setInterval(function () {
                if (document.readyState !== "complete") return;
                clearInterval(stateCheck);
                try {fn()} catch (e) {}
            }, 1000);
        };
        '.$id.'_docReady(function () {
            var clones = document.querySelectorAll(".cloned");
            Array.prototype.forEach.call(clones, function (clone) {
                clone.removeAttribute("data-subblock");
                clone.childNodes[0].removeAttribute("data-subblock");
            });

            $("#'.$id.'").owlCarousel({
                items: 1,
                margin: 0,
                loop: false,
                lazyLoad: false,
                nav: false,
                dots: false,
                smartSpeed: 1000,
                fluidSpeed: 1000,
                autoWidth: true,
                autoplay: false,
                autoplayHoverPause: false
            });
            document.getElementById("'.$id.'").style.display = "block";

            $(".owl-dots").remove();
            $(".owl-nav").remove();
        });
    </script>
';

$moduleSettings = '
    {
        "type": "slider",
        "items": 1,
        "style": "style-1",
        "transition": "slide",
        "margin": 0,
        "loop": false,
        "lazy_load": false,
        "nav": false,
        "dots": false,
        "speed": 1000,
        "autoplay": false,
        "autoplay_pause": false
    }
';
?>

<div class="row clearfix border-0">
    <div class="col-12"
         data-noedit
         data-module="slider"
         data-dialog-width="70%"
         data-module-desc="Slider"
         data-html="{{ encode_uri_component($moduleHtml) }}"
         data-settings="{{ encode_uri_component($moduleSettings) }}"
    >
    </div>
</div>
