<header
    id="header"
    class="header-3 @yield('header_class', setting()->getHeaderClass())"
    itemscope
    itemtype="http://schema.org/LocalBusiness"
>

    {{-- Header Middle--}}
    <div class="header-middle">
        <div class="container">
            <div class="row">

                {{-- Header Middle Left --}}
                <div class="col-12 col-lg-3 header-middle-left d-flex">

                    {{-- Logo --}}
                    <a class="header-top-logo d-block align-self-center"
                       href="{{ url('/') }}"
                       itemprop="image" itemscope
                       itemtype="http://schema.org/ImageObject"
                    >
                        <img class="header-logo"
                             alt="{{ setting('client::company.name') }}"
                             src="{{ setting('theme::logo.default') }}"
                             itemprop="url"
                             data-content="{{ setting('theme::logo.default') }}"
                        >
                    </a>

                    {{-- Burger Menu --}}
                    <button class="navbar-toggler ml-auto align-self-center d-lg-none"
                            type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#navbarNavDropdown"
                            aria-controls="navbarNavDropdown"
                            aria-expanded="false"
                            aria-label="Toggle navigation"
                    >
                        <i class="fas fa-bars"></i>
                    </button>
                </div>

                {{-- Header Middle Right --}}
                <div
                    class="col-12 col-lg-9 header-middle-right d-lg-flex flex-wrap align-items-lg-center justify-content-lg-end"
                >

                    {{-- Top row --}}
                    <div class="header-middle-top d-none d-lg-flex align-self-center justify-content-end w-100">
                        <nav class="sub-navbar">
                            <ul>
                                @includeIf('menu::frontend.partials.top_menu', ['key' => 'top_menu'])
                                @if(setting('client::company.email'))
                                    <li class="nav-item nav-item-email">
                                        <a href="mailto:{{ setting('client::company.email') }}"
                                           itemprop="email"
                                           data-content="{{ setting('client::company.email') }}"
                                        >
                                            <i class="fas fa-envelope me-1"></i>
                                            {{ setting('client::company.email') }}
                                        </a>
                                    </li>
                                @endif
                                @if(setting()->getClientPhoneNumber())
                                    <li class="nav-item nav-item-phone">
                                        <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                                           itemprop="telephone"
                                           data-content="{{ setting()->getClientPhoneNumber() }}"
                                        >
                                            <i class="fas fa-phone me-1"></i>
                                            {{ setting()->getClientPhoneNumber() }}
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </nav>
                    </div>

                    {{-- Bottom row --}}
                    <div class="header-middle-bottom w-100 mt-lg-3">
                        <nav class="navbar navbar-expand-lg header-middle-bottom-nav d-flex">

                            {{-- Main Menu --}}
                            <div class="collapse navbar-collapse align-self-center justify-content-end"
                                 id="navbarNavDropdown"
                            >
                                <ul class="navbar-nav">
                                    @includeIf('menu::frontend.partials.main_menu', ['key' => 'main_menu'])
                                </ul>
                            </div>

                            {{-- Social icons --}}
                            <ul class="header-social-icons social-icons d-none d-xl-block align-self-center ms-3">

                                @if(!empty(setting('client::social.facebook')))
                                    <li class="social-icons-facebook">
                                        <a href="{{ setting('client::social.facebook') }}" target="_blank"
                                           title="Facebook"
                                        >
                                            <i class="fab fa-facebook-f"></i>
                                        </a>
                                    </li>
                                @endif

                                @if(!empty(setting('client::social.twitter')))
                                    <li class="social-icons-twitter">
                                        <a href="{{ setting('client::social.twitter') }}" target="_blank"
                                           title="Twitter"
                                        >
                                            <i class="fab fa-twitter"></i>
                                        </a>
                                    </li>
                                @endif

                                @if(!empty(setting('client::social.instagram')))
                                    <li class="social-icons-instagram">
                                        <a href="{{ setting('client::social.instagram') }}" target="_blank"
                                           title="Instagram"
                                        >
                                            <i class="fab fa-instagram"></i>
                                        </a>
                                    </li>
                                @endif

                                @if(!empty(setting('client::social.youtube')))
                                    <li class="social-icons-youtube">
                                        <a href="{{ setting('client::social.youtube') }}" target="_blank"
                                           title="Youtube"
                                        >
                                            <i class="fab fa-youtube"></i>
                                        </a>
                                    </li>
                                @endif

                                @if(!empty(setting('client::social.linkedin')))
                                    <li class="social-icons-linkedin">
                                        <a href="{{ setting('client::social.linkedin') }}" target="_blank"
                                           title="Linkedin"
                                        >
                                            <i class="fab fa-linkedin-in"></i>
                                        </a>
                                    </li>
                                @endif

                                @if(!empty(setting('client::social.pinterest')))
                                    <li class="social-icons-pinterest">
                                        <a href="{{ setting('client::social.pinterest') }}" target="_blank"
                                           title="Pinterest"
                                        >
                                            <i class="fab fa-pinterest"></i>
                                        </a>
                                    </li>
                                @endif
                            </ul>

                        </nav>
                    </div>

                </div>

            </div>
        </div>
    </div>

</header>
