<header
    id="header"
    class="header-10 @yield('header_class', setting()->getHeaderClass())"
    itemscope
    itemtype="http://schema.org/LocalBusiness"
>
    {{-- Header Top --}}
    <div class="header-top">
        <div class="container-fluid container-lg">
            <div class="row">

                {{-- Header Top Left --}}
                <div class="col-md-3 order-md-1 header-top-left d-none d-lg-flex align-items-center">
                    <div class="d-flex flex-column align-items-center">

                        <div class="header-top-icon me-2 text-primary">
                            <i class="fas fa-envelope"></i>
                        </div>

                        <a class="d-none d-md-block text-decoration-none text-body"
                           href="mailto:{{ setting('client::company.email') }}"
                           itemprop="email"
                           data-content="{{ setting('client::company.email') }}"
                        >
                            {{ setting('client::company.email') }}
                        </a>

                    </div>
                </div>

                {{-- Header Top Center --}}
                <div class="col-5 col-lg-6 order-1 order-md-2 header-top-center d-flex align-items-center justify-content-lg-center">

                    {{-- Logo --}}
                    <a class="header-top-logo d-block"
                       href="{{ url('/') }}"
                       itemprop="image" itemscope
                       itemtype="http://schema.org/ImageObject"
                    >
                        <img class="header-logo"
                             alt="{{ setting('client::company.name') }}"
                             src="{{ setting('theme::logo.default') }}"
                             itemprop="url"
                             data-content="{{ setting('theme::logo.default') }}"
                        >
                    </a>

                </div>

                {{-- Header Top Right --}}
                <div class="col-7 col-lg-3 order-2 order-md-3 header-top-right d-flex align-items-center justify-content-end">

                    <div class="header-top-text text-right d-flex flex-lg-column align-items-center">
                        <div class="header-top-icon me-1 me-lg-0 text-primary">
                            <i class="fas fa-phone-alt d-none d-lg-block"></i>
                            <i class="fas fa-phone d-block d-lg-none"></i>
                        </div>

                        <a class="d-block text-decoration-none text-body"
                           href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                           itemprop="telephone"
                           data-content="{{ setting()->getClientPhoneNumber() }}"
                        >
                            {{ setting()->getClientPhoneNumber() }}
                        </a>

                    </div>

                    {{-- Burger Menu --}}
                    <button class="navbar-toggler border-0 d-lg-none"
                            type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#navbarNavDropdown"
                            aria-controls="navbarNavDropdown"
                            aria-expanded="false"
                            aria-label="Toggle navigation"
                    >
                        <i class="fas fa-bars mr-md-2"></i>
                    </button>
                </div>

            </div>
        </div>
    </div>

    {{-- Header Middle--}}
    <div class="header-middle">
        <nav class="navbar navbar-expand-lg">
            <div class="container">

                {{-- Main Menu --}}
                <div class="collapse navbar-collapse justify-content-center" id="navbarNavDropdown">
                    <ul class="navbar-nav">
                        @includeIf('menu::frontend.partials.main_menu', ['key' => 'main_menu'])
                    </ul>
                </div>

            </div>
        </nav>
    </div>

</header>
