<?php

declare(strict_types=1);

return [
    /**
     * Default Driver
     */
    'driver' => env('CAPTCHA_DRIVER', 'google'),

    /**
     * Available Drivers
     *
     * should be registered using the following format:
     * 'service' => [
     *     'domain' => 'https://service.com',
     *     'endpoint' => '/captcha-endpoint',
     *     'key' => 'your-service-key',
     *     'secret' => 'your-service-secret',
     * ],
     */
    'services' => [
        'cloudflare' => [
            'domain' => env('CAPTCHA_CLOUDFLARE_DOMAIN', 'https://www.cloudflare.com'),
            'endpoint' => env('CAPTCHA_CLOUDFLARE_ENDPOINT', '/captcha'),
            'key' => env('CAPTCHA_CLOUDFLARE_KEY'),
            'secret' => env('CAPTCHA_CLOUDFLARE_SECRET'),
        ],
        'google' => [
            'domain' => env('CAPTCHA_GOOGLE_DOMAIN', 'https://www.google.com'),
            'endpoint' => env('CAPTCHA_GOOGLE_ENDPOINT', '/recaptcha'),
            'key' => env('CAPTCHA_GOOGLE_KEY'),
            'secret' => env('CAPTCHA_GOOGLE_SECRET'),
        ],
    ],
];
