<?php

declare(strict_types=1);

namespace Bongo\Captcha\Exceptions;

use Exception;

class CaptchaException extends Exception
{
    public static function invalidProperty(string $class, string $property): self
    {
        return new self(
            trans('captcha::messages.invalid_property', [
                'class' => $class,
                'property' => $property,
            ]),
        );
    }
}
