let GoogleCaptcha = {
    field: null,
    key: null,
    action: null,
    init(uniqueId) {
        this.checkForUniqueId(uniqueId);
        this.checkForRecaptchaScript();
        this.setField(uniqueId);
        this.setKey();
        this.setAction();
        this.setForm();
        this.setEventHandler();
    },
    checkForUniqueId(uniqueId) {
        if (! uniqueId) {
            throw 'Unique ID is required for Google reCAPTCHA.';
        }
    },
    checkForRecaptchaScript() {
        if (typeof grecaptcha === 'undefined') {
            throw 'Google reCAPTCHA script not loaded.';
        }
    },
    setField(uniqueId) {
        this.field = document.getElementById(uniqueId);
        if (! this.field) {
            throw `Element with ID ${uniqueId} not found.`;
        }
    },
    setKey() {
        this.key = this.field.getAttribute('data-key');
        if (! this.key) {
            throw 'Data-key attribute is required for Google reCAPTCHA.';
        }
    },
    setAction() {
        this.action = this.field.getAttribute('data-action') || null;
    },
    setForm() {
        this.form = this.field.closest('form');
        if (! this.form) {
            throw 'Google reCAPTCHA field must be inside a form.';
        }
    },
    setEventHandler() {
        this.form.addEventListener('submit', (event) => {
            event.preventDefault();
            this.generateToken();
        });
    },
    generateToken() {
        grecaptcha.ready(() => {
            grecaptcha
                .execute(this.key, {
                    action: this.action
                })
                .then((token) => {
                    this.field.value = token;
                    this.form.submit();
                })
                .catch((error) => {
                    console.error('Recaptcha error:', error);
                });
        });
    }
}
