<?php

declare(strict_types=1);

namespace Bongo\Captcha;

use Bongo\Captcha\Managers\Captcha as CaptchaManager;
use Bongo\Framework\Providers\AbstractServiceProvider;

class CaptchaServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'captcha';

    public function register(): void
    {
        parent::register();

        $this->registerBindings();
    }

    public function boot(): void
    {
        parent::boot();

        $this->bootAssets();

        // On the application booted event
        $this->app->booted(function () {
            include __DIR__.'/helpers.php';
        });
    }

    public function registerBindings(): void
    {
        $this->app->singleton(CaptchaManager::class, function ($app) {
            return new CaptchaManager($app);
        });
    }

    public function provides(): array
    {
        return [CaptchaManager::class];
    }

    protected function bootAssets(): void
    {
        $this->publishes([__DIR__.'/../resources/dist/' => public_path()], 'captcha:assets');
    }
}
