<?php

declare(strict_types=1);

namespace Bongo\Captcha\Contracts;

use Bongo\Captcha\Services\Captcha as AbstractCaptcha;
use Illuminate\Http\Request;

interface Captcha
{
    public function verify(string $token, ?string $action = null): array;

    public function key(): string;

    public function init(): string;

    public function field(?string $action = null): string;

    public function script(?string $action = null): string;

    public function reference(): string;

    public function setRequest(Request $request): AbstractCaptcha;

    public function setReference(?string $reference = null): AbstractCaptcha;

    public function setAction(?string $action = null): AbstractCaptcha;

    public function setDomain(?string $domain = null): AbstractCaptcha;

    public function setEndpoint(?string $endpoint = null): AbstractCaptcha;

    public function setKey(?string $key = null): AbstractCaptcha;

    public function setSecret(?string $secret = null): AbstractCaptcha;

    public function setLocale(?string $locale = null): AbstractCaptcha;
}
