<?php

declare(strict_types=1);

namespace Bongo\Captcha\Managers;

use Bongo\Captcha\Contracts\Captcha as CaptchaContract;
use Bongo\Captcha\Services\CloudflareCaptcha;
use Bongo\Captcha\Services\GoogleCaptcha;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Support\Manager;

class Captcha extends Manager
{
    public function getDefaultDriver()
    {
        return $this->app['config']['captcha.driver'] ?? 'google';
    }

    /** @throws BindingResolutionException */
    public function createCloudflareDriver(): CaptchaContract
    {
        return $this->container->make(CloudflareCaptcha::class);
    }

    /** @throws BindingResolutionException */
    public function createGoogleDriver(): CaptchaContract
    {
        return $this->container->make(GoogleCaptcha::class);
    }
}
