<?php

declare(strict_types=1);

namespace Bongo\Captcha\Services;

use Bongo\Captcha\Contracts\Captcha as CaptchaContract;

class CloudflareCaptcha extends Captcha implements CaptchaContract
{
    protected ?string $name = 'cloudflare';

    public function verify(string $token, ?string $action = null): array
    {
        return [
            'success' => true,
            'score' => 1.0,
            'action' => $action ?? $this->action,
            'hostname' => $this->request->getHost(),
        ];
    }

    public function init(?string $action = null): string
    {
        return '';
    }

    public function field(?string $action = null): string
    {
        return '';
    }

    public function script(?string $action = null): string
    {
        return '';
    }
}
