# Changelog

All notable changes to `bongo/captcha` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.4] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and patterns
  - Enhanced `README.md` with comprehensive user-facing documentation
- **Initial Release**: Complete CAPTCHA verification system for Bongo framework
  - Driver-based architecture supporting multiple CAPTCHA providers
  - Google reCAPTCHA v3 full implementation
  - Cloudflare Turnstile driver structure (placeholder)
- **CaptchaServiceProvider**: Service provider extending AbstractServiceProvider
  - Auto-registers config from `src/Config/captcha.php`
  - Auto-registers translations from `src/Translations/`
  - Publishes JavaScript assets to `public/js/`
  - Registers CaptchaManager as singleton
- **CaptchaManager**: Driver manager for CAPTCHA services
  - Extends Laravel's Manager class
  - Factory methods for each driver (Google, Cloudflare)
  - Runtime driver switching support
- **GoogleCaptcha Service**: Full Google reCAPTCHA v3 implementation
  - Token verification via Google API
  - Score-based bot detection (0.0 to 1.0)
  - Action verification support
  - Hostname validation
  - Comprehensive error handling with specific exceptions
- **CloudflareCaptcha Service**: Cloudflare Turnstile integration structure
  - Driver architecture in place
  - Returns success without verification (placeholder)
- **Captcha Validation Rule**: Laravel ValidationRule implementation
  - Action parameter support
  - Minimum score threshold
  - Enable/disable toggle
  - Duplicate validation prevention (critical for API efficiency)
- **Captcha Facade**: Convenient facade access to CaptchaManager
- **Helper Function**: Global `captcha()` helper function
- **JavaScript Integration**: Frontend CAPTCHA handling
  - `google-captcha.js` - Google reCAPTCHA v3 implementation
  - Form submission handling
  - Token generation and injection
  - Firefox compatibility fixes
  - Multiple forms on same page support
  - Unique ID generation per action
- **Exception System**: Comprehensive exception hierarchy
  - `CaptchaException` - Base exception with factory method
  - `InvalidActionException` - Action mismatch
  - `InvalidRequestException` - Malformed request
  - `InvalidResponseException` - Empty/invalid API response
  - `InvalidSecretException` - Invalid secret key
  - `InvalidTokenException` - Invalid/expired token
  - `MissingSecretException` - Secret not provided
  - `MissingTokenException` - Token not provided
  - `TimeOutOrDuplicateException` - Token reuse/timeout
- **Configuration File**: Comprehensive config structure
  - Driver selection
  - Service credentials for Google and Cloudflare
  - Domain and endpoint configuration
- **Translations**: English translations
  - Exception messages (`src/Translations/en/messages.php`)
  - Validation messages (`src/Translations/en/validation.php`)
- **Multiple Forms Support**: Handle multiple CAPTCHA forms on same page
  - Unique ID generation based on action parameter
  - Separate token management per form
  - Individual submit handlers

### Changed
- **Asset Location**: Moved JavaScript files to public directory structure
  - Moved from `resources/dist/js/` to `public/js/`
  - Updated service provider publishing path
  - Better alignment with other Bongo packages
- **Enable/Disable Functionality**: Added ability to enable/disable CAPTCHA verification
  - Added `enabled` parameter to `Captcha` validation rule
  - Added `isEnabled()` method to service classes
  - Verification skipped when disabled (useful for testing)

### Fixed
- **Firefox Form Submission**: Fixed submit handler compatibility
  - Added button click event listeners for Firefox
  - Maintained form submit listeners for other browsers
  - Prevented default behavior correctly across all browsers
- **Multiple CAPTCHA Instances**: Fixed support for multiple forms on same page
  - Unique ID generation per CAPTCHA instance
  - Separate token fields for each form
  - Individual initialization per action
  - Updated `Captcha` service with `makeUniqueId()` method
  - Updated `GoogleCaptcha` service to use unique IDs
  - Updated JavaScript to handle multiple instances

### Security
- Token-based verification prevents replay attacks
- Action parameter ensures CAPTCHA was generated for specific purpose
- Score threshold allows configurable security levels
- Duplicate validation prevention reduces API calls
- Graceful error handling prevents information leakage

---

**Package**: `bongo/captcha`
**Description**: CAPTCHA verification services for Bongo framework applications
**Repository**: https://bitbucket.org/designtec/captcha
