# Bongo Dashboard

[![Latest Version](https://img.shields.io/badge/version-3.0-blue.svg)](https://designtecpackages.co.uk)
[![PHP Version](https://img.shields.io/badge/php-8.2%2B-blue.svg)](https://php.net)
[![Laravel Version](https://img.shields.io/badge/laravel-10%2B-red.svg)](https://laravel.com)

The **Bongo Dashboard** package provides the main admin dashboard landing page for the Bongo CMS system. It displays widget-based quick links to all registered admin packages and provides quick-create functionality.

## Features

- **Widget-Based Interface**: Clean, card-based layout displaying all registered admin packages
- **Quick Links**: Direct access to all package index pages
- **Quick Create**: Dropdown menu for rapidly creating new records across packages
- **Responsive Design**: Mobile-friendly grid layout (2 columns mobile, 4 columns desktop)
- **Icon Support**: Optional icon display for each package
- **Framework Integration**: Seamlessly integrates with `bongo/framework`

## Requirements

- **PHP**: 8.2 or higher
- **Laravel**: 10.0 or higher
- **Dependencies**: `bongo/framework` ^3.0

## Installation

### Via Composer

```bash
composer require bongo/dashboard
```

### Service Provider

The package uses Laravel's auto-discovery feature. The `DashboardServiceProvider` will be automatically registered.

For Laravel 5.5+, no additional configuration is needed. For older versions, manually add to `config/app.php`:

```php
'providers' => [
    // ...
    Bongo\Dashboard\DashboardServiceProvider::class,
],
```

## Usage

### Accessing the Dashboard

Once installed, the dashboard is available at:

```
/admin
```

Route name: `backend.dashboard.index`

### Authentication

The dashboard requires authentication with the `employee` role. Ensure your authentication system provides these middleware checks.

### Package Registration

The dashboard automatically displays all packages registered with the Bongo framework. Each package should provide:

- `name` - Display name
- `route` - Route prefix (e.g., `backend.page`)
- `url` - Index URL (e.g., `/admin/pages`)
- `icon` - Icon identifier (optional)

Example package structure:

```php
[
    'name' => 'Pages',
    'route' => 'backend.page',
    'url' => '/admin/pages',
    'icon' => 'document',
]
```

## Customization

### Adding Custom Dashboard Sections

You can extend the dashboard by modifying the view:

```php
// In your service provider
View::composer('dashboard::backend.index', function ($view) {
    $view->with('customData', YourModel::all());
});
```

Then update the view using Laravel's view publishing:

```bash
php artisan vendor:publish --tag=dashboard-views
```

### Translating

Publish the translation files:

```bash
php artisan vendor:publish --tag=dashboard-translations
```

Then edit `resources/lang/vendor/dashboard/en/backend.php`.

### Styling

The dashboard uses Tailwind CSS classes. To customize styling, publish the views and modify the CSS classes.

## Development

### Testing

```bash
# Run tests
vendor/bin/phpunit

# Run with coverage
vendor/bin/phpunit --coverage-html coverage
```

### Code Style

This package uses Laravel Pint for code formatting:

```bash
# Check code style
vendor/bin/pint --test

# Fix code style
vendor/bin/pint
```

### Static Analysis

```bash
vendor/bin/phpstan analyse
```

## Architecture

The package follows the standard Bongo package architecture:

- **Service Provider**: Extends `AbstractServiceProvider` for auto-registration
- **Controller**: Single `DashboardController` with `index()` method
- **Routes**: Backend-only routes with authentication middleware
- **Views**: Component-based Blade templates
- **No Database**: Presentation-only package with no models or migrations

For detailed architecture documentation, see [ARCHITECTURE.md](ARCHITECTURE.md).

## Documentation

- **[ARCHITECTURE.md](ARCHITECTURE.md)** - Detailed architecture and data flow diagrams
- **[CLAUDE.md](CLAUDE.md)** - Quick reference guide
- **[.cursorrules](.cursorrules)** - Comprehensive development guide

## Contributing

This package is part of the Bongo CMS monorepo. Each package is a separate git repository.

### Development Workflow

1. Clone the repository
2. Install dependencies: `composer install`
3. Make your changes
4. Run tests: `vendor/bin/phpunit`
5. Fix code style: `vendor/bin/pint`
6. Commit your changes

## Version History

### v3.0
- Upgraded to PHP 8.2+
- Upgraded to Laravel 10+
- Updated dependencies
- Added comprehensive documentation

### v2.0
- Legacy version for Laravel 6/7
- PHP 7.4+

### v1.0
- Initial release
- Laravel 5/6 support
- PHP 7.0+

## License

This package is proprietary software licensed under the MIT License.

## Credits

- **Author**: Stuart Elliott
- **Email**: stuart.elliott@bespokeuk.com
- **Website**: [https://bespokeuk.com](https://bespokeuk.com)

## Links

- **Repository**: [https://bitbucket.org/designtec/dashboard](https://bitbucket.org/designtec/dashboard)
- **Composer Repository**: [https://designtecpackages.co.uk](https://designtecpackages.co.uk)

## Support

For issues, questions, or feature requests, please contact the development team.
