# Changelog

All notable changes to `bongo/dashboard` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.2] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and patterns
  - Enhanced `README.md` with comprehensive user-facing documentation

### Changed
- **Laravel 10 Upgrade**: Full framework upgrade to Laravel 10.x compatibility
  - Updated DashboardServiceProvider to Laravel 10 syntax
  - Updated DashboardController for Laravel 10
  - Updated `.editorconfig` and `.styleci.yml` configurations
  - Updated composer.json dependencies
  - Updated README documentation
- **PHP 8.2 Requirement**: Minimum PHP version now 8.2
  - Added strict types declarations
  - Updated type hints throughout codebase
- **DashboardServiceProvider**: Simplified service provider
  - Removed deprecated methods
  - Cleaner boot sequence
  - Better AbstractServiceProvider integration
- **DashboardController**: Updated controller
  - Removed unnecessary methods
  - Simplified index method
  - Better framework integration
- **Routes**: Cleaned up route definitions
  - Simplified backend route structure
  - Better route naming
- **Translations**: Updated translation keys
  - Better localization support
  - Cleaned up translation files
- **Widget Partial**: Minor improvements
  - Better rendering
  - Improved styling

## [2.0.6] - 2024-10-07

### Changed
- Updated authentication credentials in `auth.json`
- Updated `.editorconfig` and `.styleci.yml` configurations
- Updated README documentation
- Added IDE configuration

### Fixed
- Minor bug fixes and improvements

---

**Package**: `bongo/dashboard`
**Description**: Admin dashboard landing page with widget-based quick links
**Repository**: https://bitbucket.org/designtec/dashboard
