@extends('framework::backend.layouts.app')
@section('page_title', 'Dashboard')

@section('content')

    @component('blade::content_header', ['hasTabs' => true])
        {{ trans('dashboard::backend.index') }}
        @slot('actions')
            @linkButton(['class' => 'lg:mr-3', 'name' => trans('dashboard::backend.website'),'url' => '/','target' => '_blank'])
            <dropdown placeholder="{{ trans('user::backend.create') }}">
                @foreach($packages as $package)
                    @if(route_exists("{$package['route']}.create") && strtolower($package['name']) !== 'settings')
                        @include('dashboard::backend.partials.quick_create', ['package' => $package])
                    @endif
                @endforeach
            </dropdown>
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="dashboard-links">
            <h3 class="text-lg leading-6 font-medium text-gray-900">
                {{ trans('dashboard::backend.quick_links') }}
            </h3>
            <div class="mt-5 grid grid-cols-2 gap-2 lg:grid-cols-4">
                @foreach($packages as $package)
                    @include('dashboard::backend.partials.widget', ['package' => $package])
                @endforeach
            </div>
        </section>
    @endcomponent
@stop
