# Changelog

All notable changes to `bongo/document` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.4] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and patterns
  - Enhanced `README.md` with comprehensive user-facing documentation
- **MakeSureUploadsDirectoryExists Action**: Directory creation helper (DT-453)
  - Ensures upload directory exists before file operations
  - Creates directory with proper permissions (0755)
  - Prevents file upload failures due to missing directories
  - Added to `src/Actions/MakeSureUploadsDirectoryExists.php`

### Changed
- **Laravel 10 Upgrade**: Full framework upgrade to Laravel 10.x compatibility
  - Updated DocumentServiceProvider to Laravel 10 syntax
  - Updated DocumentController (API and Backend) for Laravel 10
  - Updated StoreDocumentRequest for Laravel 10 validation
  - Updated Document model for Laravel 10
  - Updated migration for Laravel 10 schema
  - Updated `.editorconfig` and `.styleci.yml` configurations
  - Updated composer.json dependencies
  - Updated README documentation
- **PHP 8.2 Requirement**: Minimum PHP version now 8.2
  - Added strict types declarations
  - Updated type hints throughout codebase
- **DocumentServiceProvider**: Simplified service provider
  - Removed deprecated methods
  - Cleaner boot sequence
  - Better AbstractServiceProvider integration
- **Api\DocumentController**: Enhanced API controller
  - Added directory existence check before upload
  - Better error handling
  - Improved response format
  - Added `MakeSureUploadsDirectoryExists` action
- **Backend\DocumentController**: Updated backend controller (DT-458)
  - Added `show()` method for viewing documents
  - Added `download()` method for downloading documents
  - Better file serving with proper headers
  - Improved error handling
- **Routes**: Enhanced route structure (DT-458)
  - Added `show` route for viewing documents
  - Added `download` route for downloading documents
  - Better route naming
- **Document Model**: Updated model
  - Better relationship handling
  - Improved accessor methods
  - Enhanced scope methods
- **StoreDocumentRequest**: Enhanced validation
  - Better file type validation
  - Improved size limits
  - Cleaner validation rules
- **Migration**: Updated database schema
  - Better column types
  - Improved indexes
- **Translations**: Updated translation keys
  - Better localization support
  - Cleaned up translation files
- **Config**: Updated configuration
  - Better default paths
  - Improved allowed file types
- **Backend Index View**: Added document manager integration (DT-458)
  - Added view link support
  - Added download link support
  - Better Vue component integration

### Removed
- **HasDocuments Interface**: Removed unused interface
  - Functionality moved to standard Laravel relationships
- **Documentable Model**: Removed polymorphic relationship model
  - Simplified architecture
  - Direct document management instead
- **Documentables Migration**: Removed polymorphic relationship table
  - No longer needed with simplified architecture
- **HasDocuments Trait**: Removed unused trait
  - Standard Laravel relationships preferred
- **Backend Create/Edit/Show Views**: Removed unused views
  - Document management handled via Vue component
- **Form Partials**: Removed unused form partials
  - Vue component handles all forms

### Fixed
- **Upload Directory Permissions**: Fixed issue where uploads failed if directory didn't exist (DT-453)
  - Added automatic directory creation
  - Proper permission setting
  - Prevents upload failures

---

**Package**: `bongo/document`
**Description**: Document management functionality with file uploads and UUID-based access
**Repository**: https://bitbucket.org/designtec/document
