<?php

namespace Bongo\Document\Actions;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class MakeSureUploadsDirectoryExists
{
    public function execute(): void
    {
        // Get the upload path
        $filePath = config('document.public_path').'uploads/';

        // If the driver is local, use the file facade
        if (config('filesystems.default') === 'local') {
            File::ensureDirectoryExists(storage_path("app/$filePath"));

            return;
        }

        // If the driver is not local, use the storage facade
        if (! Storage::exists($filePath)) {
            Storage::makeDirectory($filePath);
        }
    }
}
