<?php

namespace Bongo\Document\Http\Controllers\Backend;

use Bongo\Document\Actions\MakeSureUploadsDirectoryExists;
use Bongo\Document\Models\Document;
use Bongo\Framework\Http\Controllers\AbstractController;
use Illuminate\Support\Facades\Storage;
use Illuminate\View\View;

class DocumentController extends AbstractController
{
    public function index(): View
    {
        (new MakeSureUploadsDirectoryExists())->execute();

        return view('document::backend.index');
    }

    public function show($uuid)
    {
        $document = Document::where('uuid', $uuid)->firstOrFail();

        return redirect()->away(asset($document->src));
    }

    public function download($uuid)
    {
        $document = Document::where('uuid', $uuid)->firstOrFail();

        return Storage::download($document->file_path);
    }
}
