<?php

use Bongo\Document\Seeders\PackageSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

class CreateDocumentsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('documents')) {
            Schema::create('documents', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid('uuid')->index();

                // Fields
                $table->string('name')->nullable();
                $table->string('title')->nullable();
                $table->string('path');
                $table->string('ext')->nullable();
                $table->string('size')->nullable();
                $table->string('type')->nullable();
                $table->integer('sort_order')->nullable();

                // Audit
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();
                $table->unsignedInteger('deleted_by')->nullable()->index();

                // Timestamps
                $table->timestamps();
                $table->softDeletes();
            });
        }

        // If the package table exists then seed the package
        if (Schema::hasTable('packages')) {
            Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
        }
    }

    public function down()
    {
        Schema::dropIfExists('documents');
    }
}
