<?php

namespace Bongo\Document\Models;

use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;

class Document extends AbstractModel
{
    use HasUUID;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'title',
        'path',
        'ext',
        'size',
        'type',
        'sort_order',
        'created_by',
        'updated_by',
    ];

    /**
     * The accessors to append to this model's array form.
     *
     * @var array
     */
    protected $appends = [
        'src',
    ];

    /**
     * scopeOfType()
     * retrieve all documents that are of this type.
     *
     * @param $query
     * @param $type
     *
     * @return mixed
     */
    public function scopeOfType($query, $type)
    {
        return $query->whereType($type);
    }

    /**
     * Document src attribute.
     *
     * @return string
     */
    public function getFilePathAttribute(): string
    {
        return rtrim(ltrim($this->path, '/'), '/').'/'.ltrim($this->name, '/');
    }

    /**
     * Document src attribute.
     *
     * @return string
     */
    public function getSrcAttribute(): string
    {
        return Storage::url(ltrim($this->file_path, '/'));
    }

    /**
     * Check if this document is a PDF
     *
     * @return bool
     */
    public function isPdf(): bool
    {
        return $this->ext == 'pdf';
    }
}
