<?php

namespace Bongo\Enquiry\Mailables;

use Bongo\Enquiry\Models\Enquiry;
use Illuminate\Mail\Mailable;

class AdminEnquiryMailable extends Mailable
{
    /** @var Enquiry */
    protected Enquiry $enquiry;

    public function __construct(Enquiry $enquiry)
    {
        $this->enquiry = $enquiry;
    }

    public function build(): AdminEnquiryMailable
    {
        return $this
            ->from(
                config("settings.mail_from_address"),
                config("settings.mail_from_name")
            )
            ->replyTo(
                $this->enquiry->getEmail(),
                $this->enquiry->getName(),
            )
            ->subject('New enquiry from: '. $this->enquiry->getEmail())
            ->view('enquiry::mail.admin_enquiry', [
                'enquiry' => $this->enquiry,
            ])
            ->text('enquiry::mail.admin_enquiry_plain', [
                'enquiry' => $this->enquiry,
            ]);
    }
}
