<?php

namespace Bongo\Enquiry\Mailables;

use Bongo\Enquiry\Models\Enquiry;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Mail\Mailable;

class EnquiryMailable extends Mailable
{
    /** @var Enquiry */
    protected Enquiry $enquiry;

    public function __construct(Enquiry $enquiry)
    {
        $this->enquiry = $enquiry;
    }

    /**
     * @throws BindingResolutionException
     */
    public function build(): EnquiryMailable
    {
        $mailable = $this;

        $mailable->from(
            config("settings.mail_from_address"),
            config("settings.mail_from_name")
        );
        $mailable->replyTo(
            setting("client::company.email"),
            setting("client::company.name"),
        );

        if (! empty(setting("client::company.bcc_email"))) {
            $mailable->bcc(setting("client::company.bcc_email"));
        }

        $mailable->subject('Thank you for your enquiry');
        $mailable->view('enquiry::mail.enquiry', [
            'enquiry' => $this->enquiry,
        ]);
        $mailable->text('enquiry::mail.enquiry_plain', [
            'enquiry' => $this->enquiry,
        ]);

        return $mailable;
    }
}
