<?php

namespace Bongo\Enquiry\Models;

/**
 * Class Enquiry
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Enquiry\Models
 */
class Enquiry
{
    /** @var */
    protected $name;

    /** @var */
    protected $firstName;

    /** @var */
    protected $lastName;

    /** @var */
    protected $email;

    /** @var */
    protected $phone;

    /** @var */
    protected $message;

    /** @var */
    protected $address;

    /** @var */
    protected $postcode;

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param $name
     */
    public function setName($name)
    {
        if (!empty($name)) {
            $this->name = ucwords($name);
        }
    }

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @param $firstName
     */
    public function setFirstName($firstName)
    {
        if (!empty($firstName)) {
            $this->firstName = ucfirst($firstName);
        }
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    /**
     * @param $lastName
     */
    public function setLastName($lastName)
    {
        if (!empty($lastName)) {
            $this->lastName = ucfirst($lastName);
        }
    }

    /**
     * @return string|null
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param $email
     */
    public function setEmail($email)
    {
        if (!empty($email)) {
            $this->email = strtolower($email);
        }
    }

    /**
     * @return string|null
     */
    public function getPhone(): ?string
    {
        return $this->phone;
    }

    /**
     * @param $phone
     */
    public function setPhone($phone)
    {
        if (!empty($phone)) {
            $this->phone = $phone;
        }
    }

    /**
     * @return string|null
     */
    public function getAddress(): ?string
    {
        return $this->address;
    }

    /**
     * @param $address
     */
    public function setAddress($address)
    {
        if (!empty($address)) {
            $this->address = $address;
        }
    }

    /**
     * @return string|null
     */
    public function getPostcode(): ?string
    {
        return $this->postcode;
    }

    /**
     * @param $postcode
     */
    public function setPostcode($postcode)
    {
        if (!empty($postcode)) {
            $this->postcode = $postcode;
        }
    }

    /**
     * @return string|null
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @param $message
     */
    public function setMessage($message)
    {
        if (!empty($message)) {
            $this->message = $message;
        }
    }
}
