<?php

use Illuminate\Support\Facades\Route;
use Spatie\Honeypot\ProtectAgainstSpam;

/*
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
Route::namespace('Bongo\Enquiry\Http\Controllers')
     ->middleware('web')
     ->group(function () {

         // Frontend Routes...
         Route::namespace('Frontend')
              ->as('frontend.')
              ->group(function () {

                  // Enquiry
                  Route::prefix(config('enquiry.prefix'))
                       ->as('enquiry.')
                       ->group(function () {

                           Route::post('store')
                                ->name('store')
                                ->uses('EnquiryController@store')
                                ->middleware(ProtectAgainstSpam::class);

                       });
              });
     });
