@extends('framework::mail.layouts.app')

@php
    $cellStyle = 'padding-top: 10px; padding-right: 0; padding-bottom: 10px; padding-left: 0; border:0';
@endphp

@section('content')

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <h1 style="margin-top:0; margin-bottom:0; font-size:26px; line-height:32px; font-weight:bold; letter-spacing:-0.02em;">
            New website enquiry
        </h1>
    @endcomponent

    @component('framework::mail.layouts.partials.section')
        <table width="100%" cellpadding="0" border="0" cellspacing="0">

            @if(config('enquiry.show_referrer') && !empty(get_referrer()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Referrer</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ get_referrer() }}
                    </td>
                </tr>
            @endif

            @if(! empty($enquiry->getName()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Name</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $enquiry->getName() }}
                    </td>
                </tr>
            @endif

            @if(! empty($enquiry->getFirstName()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>First Name</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $enquiry->getFirstName() }}
                    </td>
                </tr>
            @endif

            @if(! empty($enquiry->getLastName()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Last Name</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $enquiry->getLastName() }}
                    </td>
                </tr>
            @endif

            @if(!empty($enquiry->getEmail()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Email</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $enquiry->getEmail() }}
                    </td>
                </tr>
            @endif

            @if(!empty($enquiry->getPhone()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Phone</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $enquiry->getPhone() }}
                    </td>
                </tr>
            @endif

            @if(!empty($enquiry->getAddress()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Address</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $enquiry->getAddress() }}
                    </td>
                </tr>
            @endif

            @if(!empty($enquiry->getPostcode()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Postcode</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $enquiry->getPostcode() }}
                    </td>
                </tr>
            @endif

            @if(!empty($enquiry->getMessage()))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Message</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $enquiry->getMessage() }}
                    </td>
                </tr>
            @endif

        </table>
    @endcomponent

@stop
