# Changelog

All notable changes to `bongo/enquiry` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.7] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` (479 lines) - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` (473 lines) - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` (1,212 lines) - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` (522 lines) - GitHub Copilot code templates and patterns
- **Enhanced README.md**: Expanded with comprehensive installation, usage, and integration sections (424 new lines)

## [3.0.0] - 2025-11-18

### Major Release - v3.0

This major version includes significant improvements to spam protection, validation, and integration with the bongo framework ecosystem.

### Changed
- **Custom Captcha Package Integration**: Updated to use new custom captcha package
  - Refactored `StoreEnquiryRequest` to use `Bongo\Captcha\Rules\Captcha` validation rule
  - Simplified captcha validation logic (6 insertions, 14 deletions)
  - Better integration with framework-level captcha functionality

### Added
- **DT-547**: Google ReCaptcha Score Configuration
  - New `recaptcha.min_score` config option in `src/Config/enquiry.php`
  - Configurable score threshold for reCAPTCHA validation (default: 0.5)
  - Enhanced `StoreEnquiryRequest` to support score-based validation
  - More flexible spam detection based on user interaction scores

### Improved
- **ReCaptcha Functionality Updates**: Modernized reCAPTCHA implementation
  - Updated `EnquiryController` to use new reCAPTCHA methods
  - Added `recaptcha.enabled` config key for package-level control
  - Refactored `StoreEnquiryRequest` validation to use framework helpers
  - Consolidated reCAPTCHA logic (30 insertions, 31 deletions)

### Dependency Updates
- **Framework-Level Dependencies**: Moved honeypot and reCAPTCHA to framework level
  - Updated `composer.json` to remove redundant dependencies
  - Better dependency management and version consistency
  - Reduced package size and improved maintainability

### Service Provider Modernization
- **V3.0 Architecture**: Merged v3.0 branch improvements
  - Extended `AbstractServiceProvider` from bongo/framework
  - Automatic registration of config, routes, views, translations
  - Simplified service provider from manual registration to convention-based
  - Updated `.editorconfig` (438 line update) for consistent formatting
  - Updated `.styleci.yml` (14 line update) for Laravel 10 code style

### Email System Enhancements
- **New Email Templates**: Added comprehensive email views
  - `src/Views/mail/admin_enquiry.blade.php` - Rich HTML admin notification (120 lines)
  - `src/Views/mail/admin_enquiry_plain.blade.php` - Plain text admin notification (29 lines)
  - `src/Views/mail/crm_plain.blade.php` - Plain text CRM notification (27 lines)
  - Enhanced `src/Views/mail/enquiry.blade.php` - User confirmation email (59+ lines)
  - Enhanced `src/Views/mail/enquiry_plain.blade.php` - Plain text user confirmation (31+ lines)

- **New Mailable Classes**: Structured email handling
  - `src/Mailables/AdminEnquiryMailable.php` - Admin notification mailable (37 lines)
  - `src/Mailables/CrmMailable.php` - CRM notification mailable (30 lines)
  - Enhanced `src/Mailables/EnquiryMailable.php` - User confirmation mailable with reply-to support

### Controller Improvements
- **Enhanced EnquiryController**: Modernized request handling
  - Updated `src/Http/Controllers/Frontend/EnquiryController.php` with improved logic (43+ lines modified)
  - Better integration with new mailable classes
  - Improved error handling and success redirection
  - Support for multiple email recipients (user, admin, CRM)

### Model Refactoring
- **Enquiry Model Enhancements**: Complete refactor to DTO pattern
  - Refactored `src/Models/Enquiry.php` (149 line update)
  - Added proper getter/setter methods for all properties
  - Implemented automatic text formatting (ucwords, ucfirst, strtolower)
  - Better type safety with nullable type declarations
  - No database persistence (DTO-based design)

### Routing Updates
- **New Route Structure**: Modernized routing
  - Created `src/Routes/frontend.php` with named routes (13 lines)
  - Removed `src/Routes/web.php` (35 deletions)
  - Better route naming convention with `frontend.` prefix
  - Consistent with framework routing standards

### Testing Infrastructure
- **Enhanced Test Suite**: Improved testing setup
  - Updated `tests/TestCase.php` with Orchestra Testbench (26+ lines modified)
  - Better integration testing support
  - Laravel 10 compatibility

### Configuration
- **New Config Options**: Enhanced configuration
  - Added `show_referrer` option to display HTTP referrer in emails
  - Added `crm_email` option for optional CRM notifications
  - Added `recaptcha.enabled` package-level toggle
  - Added `recaptcha.min_score` for score threshold

### Statistics
- **22 files changed** with 960 insertions and 291 deletions
- Complete email system overhaul with 3 new mailables
- Modern DTO-based model architecture
- Framework-integrated validation and spam protection

## [2.0.17] - 2024-08-05

### Added
- **DT-417**: Google ReCaptcha Implementation
  - Added reCAPTCHA v3 validation to `StoreEnquiryRequest`
  - Integrated with Google's reCAPTCHA API
  - Added 15 lines of validation logic
  - Removed old captcha dependency from `composer.json`

### Fixed
- **DT-310**: Enquiry Success URL Configuration
  - Added `success_url` config option in `src/Config/enquiry.php`
  - Updated `EnquiryController` to use configurable redirect URL
  - Allows customization of post-submission redirect

- **Type Declaration Errors**: Fixed missing type declaration errors
  - Updated `src/Models/Enquiry.php` with proper type hints
  - Improved PHP 8.2 compatibility

## [2.0.0] - 2023-04-24

### Changed
- **Laravel 10 & PHP 8.2 Upgrade**: Complete framework upgrade
  - Updated `composer.json` for Laravel 10 compatibility
  - Updated codebase for PHP 8.2 compatibility
  - Modernized type declarations and nullable types
  - Updated Pint and StyleCI configurations

### Added
- **DT-294**: Mailable Reply-To Address
  - Added reply-to functionality to mailables
  - Admin emails now have reply-to set to user's email
  - User emails now have reply-to set to admin email
  - Better email conversation threading

- **DT-294**: Contact Form Admin Email
  - New admin notification mailable
  - Separate email sent to admin on form submission
  - Configurable admin email address via settings

- **DT-276**: Enquiry CRM Email
  - Optional CRM email notification
  - Configurable CRM recipient via config
  - Plain text email format for CRM integration

- **DT-270**: Enquiry Form Updates
  - Enhanced form field support
  - Improved validation rules
  - Better error messaging

### Improved
- **Mail Configuration**: Enhanced email handling
  - Updated from address to use config settings
  - Added reply-to headers for better email flow
  - Configurable mail from name and address via `DT-199`

- **DT-222**: Referrer URLs
  - Added HTTP referrer tracking
  - Configurable display in admin emails
  - Better analytics and source tracking

### Fixed
- **DT-200**: Enquiry Email Typo
  - Fixed typo in email template
  - Improved email template readability

- **DT-194**: Various bug fixes and improvements

## [1.0.0] - 2021-09-07

### Added
- **DT-158**: Address Field
  - Added address and postcode fields to enquiry form
  - Optional fields with validation
  - Included in email notifications

### Changed
- **PHP 7.4 Requirement**: Updated minimum PHP version
  - Updated `composer.json` to require PHP 7.4+
  - Modernized codebase for PHP 7.4 features

- **Composer Updates**: Prepared for Satis repository
  - Updated composer configuration
  - Ready for private package distribution

### Email Templates
- **New Email Design**: Styled email templates
  - Created modern HTML email templates
  - Added plain text alternatives
  - Responsive design for all devices
  - Extends `framework::mail.layouts.app` layout

### Initial Release
- Contact form submission handling
- Email notifications (user + admin)
- Spam protection with honeypot
- Form validation with RFC/DNS email validation
- DTO-based enquiry model (no database)
- Integration with bongo/framework

---

**Package**: `bongo/enquiry`
**Repository**: https://bitbucket.org/designtec/enquiry
**Private Composer Repository**: https://designtecpackages.co.uk
