<?php

namespace Bongo\Enquiry\Http\Requests;

use Bongo\Captcha\Rules\Captcha;
use Illuminate\Foundation\Http\FormRequest;

class StoreEnquiryRequest extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('enquiry.recaptcha.enabled');
        $recaptchaMinScore = config('enquiry.recaptcha.min_score', 0.5);

        return [
            'name' => 'sometimes|required',
            'first_name' => 'sometimes|required',
            'last_name' => 'sometimes|required',
            'email' => 'required|string|email:rfc,dns',
            'phone' => 'sometimes|required',
            'address' => 'sometimes|required',
            'postcode' => 'sometimes|required',
            'message' => 'sometimes|required',

            'captcha-response' => new Captcha(
                action: 'enquiry',
                minScore: $recaptchaMinScore,
                enabled: $recaptchaEnabled,
            ),
        ];
    }
}
