<?php

namespace Bongo\Enquiry\Models;

class Enquiry
{
    protected ?string $name = null;

    protected ?string $firstName = null;

    protected ?string $lastName = null;

    protected ?string $email = null;

    protected ?string $phone = null;

    protected ?string $message = null;

    protected ?string $address = null;

    protected ?string $postcode = null;

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): void
    {
        if (! empty($name)) {
            $this->name = ucwords($name);
        }
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): void
    {
        if (! empty($firstName)) {
            $this->firstName = ucfirst($firstName);
        }
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): void
    {
        if (! empty($lastName)) {
            $this->lastName = ucfirst($lastName);
        }
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): void
    {
        if (! empty($email)) {
            $this->email = strtolower($email);
        }
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(?string $phone): void
    {
        if (! empty($phone)) {
            $this->phone = $phone;
        }
    }

    public function getAddress(): ?string
    {
        return $this->address;
    }

    public function setAddress(?string $address): void
    {
        if (! empty($address)) {
            $this->address = $address;
        }
    }

    public function getPostcode(): ?string
    {
        return $this->postcode;
    }

    public function setPostcode(?string $postcode): void
    {
        if (! empty($postcode)) {
            $this->postcode = $postcode;
        }
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(?string $message): void
    {
        if (! empty($message)) {
            $this->message = $message;
        }
    }
}
