<?php

namespace Bongo\Enquiry\Http\Controllers\Frontend;

use Bongo\Enquiry\Http\Requests\StoreEnquiryRequest;
use Bongo\Enquiry\Mailables\AdminEnquiryMailable;
use Bongo\Enquiry\Mailables\CrmMailable;
use Bongo\Enquiry\Mailables\EnquiryMailable;
use Bongo\Enquiry\Models\Enquiry;
use Bongo\Framework\Http\Controllers\AbstractController;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Mail;

class EnquiryController extends AbstractController
{
    /**
     * @throws BindingResolutionException
     */
    public function store(StoreEnquiryRequest $request): RedirectResponse
    {
        // Get the post data
        $enquiry = new Enquiry();
        $enquiry->setName($request->get('name'));
        $enquiry->setFirstName($request->get('first_name'));
        $enquiry->setLastName($request->get('last_name'));
        $enquiry->setPhone($request->get('phone'));
        $enquiry->setEmail($request->get('email'));
        $enquiry->setAddress($request->get('address'));
        $enquiry->setPostcode($request->get('postcode'));
        $enquiry->setMessage($request->get('message'));

        // Send the email to the user
        Mail::to($enquiry->getEmail())
            ->send(new EnquiryMailable($enquiry));

        // Send the email to the admin
        Mail::to(setting("client::company.email"))
            ->send(new AdminEnquiryMailable($enquiry));

        // Check / send CRM email
        if (config('enquiry.crm_email') && ! empty(config('enquiry.crm_email'))) {
            Mail::to(config('enquiry.crm_email'))
                ->send(new CrmMailable($enquiry));
        }

        // Redirect the user to the thank-you screen
        return redirect()
            ->to(config('enquiry.success_url'))
            ->success(trans('enquiry::frontend.store_success'));
    }
}
