<?php

namespace Bongo\Enquiry\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreEnquiryRequest extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('enquiry.recaptcha.enabled');
        $recaptchaMinScore = config('enquiry.recaptcha.min_score', 0.5);

        return [
            'name' => 'sometimes|required',
            'first_name' => 'sometimes|required',
            'last_name' => 'sometimes|required',
            'email' => 'required|string|email:rfc,dns',
            'phone' => 'sometimes|required',
            'address' => 'sometimes|required',
            'postcode' => 'sometimes|required',
            'message' => 'sometimes|required',

            'g-recaptcha-response' => [
                "recaptchav3:enquiry,{$recaptchaMinScore},",
                Rule::requiredIf(fn () => $recaptchaEnabled),
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'g-recaptcha-response' => [
                'recaptchav3' => 'reCAPTCHA validation failed, please try again or contact us for more assistance',
            ],
        ];
    }
}
