<?php

namespace Bongo\Enquiry\Mailables;

use Bongo\Enquiry\Models\Enquiry;
use Illuminate\Mail\Mailable;

class CrmMailable extends Mailable
{
    /** @var Enquiry */
    protected Enquiry $enquiry;

    public function __construct(Enquiry $enquiry)
    {
        $this->enquiry = $enquiry;
    }

    public function build(): CrmMailable
    {
        return $this
            ->from(
                config("settings.mail_from_address"),
                config("settings.mail_from_name")
            )
            ->subject('New enquiry from: '.$this->enquiry->getEmail())
            ->text('enquiry::mail.crm_plain', [
                'enquiry' => $this->enquiry,
            ]);
    }
}
