<?php

namespace Bongo\Enum;

use Bongo\Enum\Services\Enum;
use Bongo\Framework\Providers\AbstractServiceProvider;
use Exception;

class EnumServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'enum';

    public function register(): void
    {
        parent::register();
        $this->app->bind('enum', Enum::class);
    }

    /**
     * @throws Exception
     */
    public function boot(): void
    {
        parent::register();

        // Once the app is booted register the helpers
        $this->app->booted(function () {
            include __DIR__.'/helpers.php';
        });
    }
}
