<?php

namespace Bongo\Enum\Services;

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class Enum
{
    public static function getValues(string $table, string $column): array
    {
        return Cache::remember($table.'.'.$column, config('settings.cache_default'),
            function () use ($table, $column) {

                // Query the column on the table
                $type = DB::select("SHOW COLUMNS FROM $table WHERE Field = '$column'")[0]->Type;

                // Get the values via regex
                preg_match('/^enum\((.*)\)$/', $type, $matches);

                // Get all the enums from the regex
                $enums = [];
                foreach (explode(',', $matches[1]) as $value) {
                    $v = trim($value, "'");
                    $enums = Arr::add($enums, $v, $v);
                }

                // If there were enums put them into an array for the caller
                $enumValues = [];
                if (count($enums) > 0) {
                    foreach ($enums as $enum) {
                        $enumValues[$enum] = ucwords(str_replace('_', ' ', $enum));
                    }
                }

                return $enumValues;
            }
        );
    }
}
