<?php

declare(strict_types=1);

namespace Bongo\Estimate\Actions;

use Bongo\Estimate\Interfaces\StatusInterface;
use Bongo\Estimate\Models\Estimate;
use Bongo\Estimate\Models\EstimateItem;

class CleanUpOldEstimates
{
    public static function execute(): void
    {
        // Delete any old estimate items
        EstimateItem::query()
            ->where('status', StatusInterface::DRAFT)
            ->where('created_at', '<', now()->subDays(config('estimate.cleanup_days')))
            ->forceDelete();

        // Delete any old estimates
        Estimate::query()
            ->where('status', StatusInterface::DRAFT)
            ->where('created_at', '<', now()->subDays(config('estimate.cleanup_days')))
            ->forceDelete();
    }
}
