<?php

declare(strict_types=1);

namespace Bongo\Estimate\Actions;

use Bongo\Estimate\Interfaces\StatusInterface;
use Bongo\Estimate\Models\EstimateItem;

class FindEstimateItem
{
    public static function byUuid(?string $uuid): ?EstimateItem
    {
        return EstimateItem::query()
            ->with(['service', 'prices.plan'])
            ->where('uuid', $uuid)
            ->whereIn('status', [
                StatusInterface::DRAFT,
                StatusInterface::PENDING
            ])
            ->first();
    }
}
